/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.spigot.shaded.me.lucko.commodore.file;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import org.geysermc.geyser.platform.spigot.shaded.me.lucko.commodore.file.ArgumentTypeParser;
import org.geysermc.geyser.platform.spigot.shaded.me.lucko.commodore.file.ParseException;
import org.geysermc.geyser.platform.spigot.shaded.me.lucko.commodore.file.Token;
import org.geysermc.geyser.platform.spigot.shaded.me.lucko.commodore.file.TokenStream;

public class BrigadierArgumentTypeParser
implements ArgumentTypeParser {
    public static final BrigadierArgumentTypeParser INSTANCE = new BrigadierArgumentTypeParser();

    private BrigadierArgumentTypeParser() {
    }

    @Override
    public boolean canParse(String namespace, String name) {
        if (!namespace.equals("brigadier")) {
            return false;
        }
        switch (name) {
            case "bool": 
            case "string": 
            case "integer": 
            case "long": 
            case "float": 
            case "double": {
                return true;
            }
        }
        return false;
    }

    @Override
    public ArgumentType<?> parse(String namespace, String name, TokenStream tokens) throws ParseException {
        switch (name) {
            case "bool": {
                return BoolArgumentType.bool();
            }
            case "string": {
                return BrigadierArgumentTypeParser.parseStringArgumentType(tokens);
            }
            case "integer": {
                return BrigadierArgumentTypeParser.parseIntegerArgumentType(tokens);
            }
            case "long": {
                return BrigadierArgumentTypeParser.parseLongArgumentType(tokens);
            }
            case "float": {
                return BrigadierArgumentTypeParser.parseFloatArgumentType(tokens);
            }
            case "double": {
                return BrigadierArgumentTypeParser.parseDoubleArgumentType(tokens);
            }
        }
        throw new AssertionError();
    }

    private static StringArgumentType parseStringArgumentType(TokenStream tokens) throws ParseException {
        String stringType;
        Token token = tokens.next();
        if (!(token instanceof Token.StringToken)) {
            throw tokens.createException("Expected string token for string type but got " + token);
        }
        switch (stringType = ((Token.StringToken)token).getString()) {
            case "single_word": {
                return StringArgumentType.word();
            }
            case "quotable_phrase": {
                return StringArgumentType.string();
            }
            case "greedy_phrase": {
                return StringArgumentType.greedyString();
            }
        }
        throw tokens.createException("Unknown string type: " + stringType);
    }

    private static IntegerArgumentType parseIntegerArgumentType(TokenStream tokens) throws ParseException {
        if (tokens.peek() instanceof Token.StringToken) {
            int min2 = BrigadierArgumentTypeParser.parseInt(tokens);
            if (tokens.peek() instanceof Token.StringToken) {
                int max = BrigadierArgumentTypeParser.parseInt(tokens);
                return IntegerArgumentType.integer((int)min2, (int)max);
            }
            return IntegerArgumentType.integer((int)min2);
        }
        return IntegerArgumentType.integer();
    }

    private static LongArgumentType parseLongArgumentType(TokenStream tokens) throws ParseException {
        if (tokens.peek() instanceof Token.StringToken) {
            long min2 = BrigadierArgumentTypeParser.parseLong(tokens);
            if (tokens.peek() instanceof Token.StringToken) {
                long max = BrigadierArgumentTypeParser.parseLong(tokens);
                return LongArgumentType.longArg((long)min2, (long)max);
            }
            return LongArgumentType.longArg((long)min2);
        }
        return LongArgumentType.longArg();
    }

    private static FloatArgumentType parseFloatArgumentType(TokenStream tokens) throws ParseException {
        if (tokens.peek() instanceof Token.StringToken) {
            float min2 = BrigadierArgumentTypeParser.parseFloat(tokens);
            if (tokens.peek() instanceof Token.StringToken) {
                float max = BrigadierArgumentTypeParser.parseFloat(tokens);
                return FloatArgumentType.floatArg((float)min2, (float)max);
            }
            return FloatArgumentType.floatArg((float)min2);
        }
        return FloatArgumentType.floatArg();
    }

    private static DoubleArgumentType parseDoubleArgumentType(TokenStream tokens) throws ParseException {
        if (tokens.peek() instanceof Token.StringToken) {
            double min2 = BrigadierArgumentTypeParser.parseDouble(tokens);
            if (tokens.peek() instanceof Token.StringToken) {
                double max = BrigadierArgumentTypeParser.parseDouble(tokens);
                return DoubleArgumentType.doubleArg((double)min2, (double)max);
            }
            return DoubleArgumentType.doubleArg((double)min2);
        }
        return DoubleArgumentType.doubleArg();
    }

    private static int parseInt(TokenStream tokens) throws ParseException {
        Token token = tokens.next();
        if (!(token instanceof Token.StringToken)) {
            throw tokens.createException("Expected string token for integer but got " + token);
        }
        String value = ((Token.StringToken)token).getString();
        if (value.equals("min")) {
            return Integer.MIN_VALUE;
        }
        if (value.equals("max")) {
            return Integer.MAX_VALUE;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw tokens.createException("Expected int but got " + value, e);
        }
    }

    private static long parseLong(TokenStream tokens) throws ParseException {
        Token token = tokens.next();
        if (!(token instanceof Token.StringToken)) {
            throw tokens.createException("Expected string token for long but got " + token);
        }
        String value = ((Token.StringToken)token).getString();
        if (value.equals("min")) {
            return Long.MIN_VALUE;
        }
        if (value.equals("max")) {
            return Long.MAX_VALUE;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw tokens.createException("Expected long but got " + value, e);
        }
    }

    private static float parseFloat(TokenStream tokens) throws ParseException {
        Token token = tokens.next();
        if (!(token instanceof Token.StringToken)) {
            throw tokens.createException("Expected string token for float but got " + token);
        }
        String value = ((Token.StringToken)token).getString();
        if (value.equals("min")) {
            return Float.MIN_VALUE;
        }
        if (value.equals("max")) {
            return Float.MAX_VALUE;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            throw tokens.createException("Expected float but got " + value, e);
        }
    }

    private static double parseDouble(TokenStream tokens) throws ParseException {
        Token token = tokens.next();
        if (!(token instanceof Token.StringToken)) {
            throw tokens.createException("Expected string token for double but got " + token);
        }
        String value = ((Token.StringToken)token).getString();
        if (value.equals("min")) {
            return Double.MIN_VALUE;
        }
        if (value.equals("max")) {
            return Double.MAX_VALUE;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw tokens.createException("Expected double but got " + value);
        }
    }
}

