/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry;

import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.registry.Registry;
import org.geysermc.geyser.registry.loader.RegistryLoader;

public class ArrayRegistry<M>
extends Registry<M[]> {
    protected <I> ArrayRegistry(I input, RegistryLoader<I, M[]> registryLoader) {
        super(input, registryLoader);
    }

    public @Nullable M get(int index) {
        if (index >= ((Object[])this.mappings).length) {
            return null;
        }
        return (M)((Object[])this.mappings)[index];
    }

    public M getOrDefault(int index, M defaultValue) {
        M value = this.get(index);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public M register(int index, M value) {
        M m4 = value;
        ((Object[])this.mappings)[index] = m4;
        return m4;
    }

    public static <I, M> ArrayRegistry<M> create(Supplier<RegistryLoader<I, M[]>> registryLoader) {
        return new ArrayRegistry<M>(null, registryLoader.get());
    }

    public static <I, M> ArrayRegistry<M> create(I input, Supplier<RegistryLoader<I, M[]>> registryLoader) {
        return new ArrayRegistry<M>(input, registryLoader.get());
    }

    public static <I, M> ArrayRegistry<M> create(RegistryLoader<I, M[]> registryLoader) {
        return new ArrayRegistry<M>(null, registryLoader);
    }

    public static <I, M> ArrayRegistry<M> create(I input, RegistryLoader<I, M[]> registryLoader) {
        return new ArrayRegistry<M>(input, registryLoader);
    }
}

