/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.hashing;

import java.util.function.Supplier;
import org.geysermc.geyser.item.hashing.MapBuilder;
import org.geysermc.geyser.item.hashing.MinecraftHasher;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.KeybindComponent;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.NBTComponent;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.ScoreComponent;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.SelectorComponent;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.TextComponent;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.TranslatableComponent;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.event.ClickEvent;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.event.HoverEvent;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.format.NamedTextColor;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.format.ShadowColor;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.format.Style;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.format.StyleGetter;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.format.TextColor;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.format.TextDecoration;

public interface ComponentHasher {
    public static final MinecraftHasher<Component> COMPONENT = MinecraftHasher.lazyInitialize(new Supplier<MinecraftHasher<Component>>(){

        @Override
        public MinecraftHasher<Component> get() {
            return ACTUAL_COMPONENT;
        }
    });
    public static final MinecraftHasher<NamedTextColor> NAMED_COLOR = MinecraftHasher.STRING.cast(NamedTextColor::toString);
    public static final MinecraftHasher<TextColor> DIRECT_COLOR = MinecraftHasher.STRING.cast(TextColor::asHexString);
    public static final MinecraftHasher<TextColor> COLOR = (value, encoder) -> {
        if (value instanceof NamedTextColor) {
            NamedTextColor named = (NamedTextColor)value;
            return NAMED_COLOR.hash(named, encoder);
        }
        return DIRECT_COLOR.hash((TextColor)value, encoder);
    };
    public static final MinecraftHasher<TextDecoration.State> DECORATION_STATE = MinecraftHasher.BOOL.cast(state -> switch (state) {
        default -> throw new IncompatibleClassChangeError();
        case TextDecoration.State.NOT_SET -> null;
        case TextDecoration.State.FALSE -> false;
        case TextDecoration.State.TRUE -> true;
    });
    public static final MinecraftHasher<ClickEvent.Action> CLICK_EVENT_ACTION = MinecraftHasher.STRING.cast(ClickEvent.Action::toString);
    public static final MinecraftHasher<ClickEvent> CLICK_EVENT = CLICK_EVENT_ACTION.dispatch("action", ClickEvent::action, action -> switch (action) {
        default -> throw new IncompatibleClassChangeError();
        case ClickEvent.Action.OPEN_URL -> builder -> builder.accept("url", MinecraftHasher.STRING, ClickEvent::value);
        case ClickEvent.Action.OPEN_FILE -> builder -> builder.accept("path", MinecraftHasher.STRING, ClickEvent::value);
        case ClickEvent.Action.RUN_COMMAND, ClickEvent.Action.SUGGEST_COMMAND -> builder -> builder.accept("command", MinecraftHasher.STRING, ClickEvent::value);
        case ClickEvent.Action.CHANGE_PAGE -> builder -> builder.accept("page", MinecraftHasher.STRING, ClickEvent::value);
        case ClickEvent.Action.COPY_TO_CLIPBOARD -> builder -> builder.accept("value", MinecraftHasher.STRING, ClickEvent::value);
    });
    public static final MinecraftHasher<HoverEvent.Action<?>> HOVER_EVENT_ACTION = MinecraftHasher.STRING.cast(HoverEvent.Action::toString);
    public static final MinecraftHasher<HoverEvent<?>> HOVER_EVENT = HOVER_EVENT_ACTION.dispatch("action", HoverEvent::action, action -> {
        if (action == HoverEvent.Action.SHOW_TEXT) {
            return builder -> builder.accept("value", COMPONENT, event -> (Component)event.value());
        }
        if (action == HoverEvent.Action.SHOW_ITEM) {
            return builder -> builder.accept("id", MinecraftHasher.KEY, event -> ((HoverEvent.ShowItem)event.value()).item()).accept("count", MinecraftHasher.INT, event -> ((HoverEvent.ShowItem)event.value()).count());
        }
        return builder -> builder.accept("id", MinecraftHasher.KEY, event -> ((HoverEvent.ShowEntity)event.value()).type()).accept("uuid", MinecraftHasher.UUID, event -> ((HoverEvent.ShowEntity)event.value()).id()).optionalNullable("name", COMPONENT, event -> ((HoverEvent.ShowEntity)event.value()).name());
    });
    public static final MapBuilder<Style> STYLE = builder -> builder.optionalNullable("color", COLOR, Style::color).optionalNullable("shadow_color", MinecraftHasher.INT.cast(ShadowColor::value), StyleGetter::shadowColor).optional("bold", DECORATION_STATE, style -> style.decoration(TextDecoration.BOLD), TextDecoration.State.NOT_SET).optional("italic", DECORATION_STATE, style -> style.decoration(TextDecoration.ITALIC), TextDecoration.State.NOT_SET).optional("underlined", DECORATION_STATE, style -> style.decoration(TextDecoration.UNDERLINED), TextDecoration.State.NOT_SET).optional("strikethrough", DECORATION_STATE, style -> style.decoration(TextDecoration.STRIKETHROUGH), TextDecoration.State.NOT_SET).optional("obfuscated", DECORATION_STATE, style -> style.decoration(TextDecoration.OBFUSCATED), TextDecoration.State.NOT_SET).optionalNullable("click_event", CLICK_EVENT, Style::clickEvent).optionalNullable("hover_event", HOVER_EVENT, Style::hoverEvent).optionalNullable("insertion", MinecraftHasher.STRING, Style::insertion).optionalNullable("font", MinecraftHasher.KEY, Style::font);
    public static final MinecraftHasher<TextComponent> SIMPLE_TEXT_COMPONENT = MinecraftHasher.STRING.cast(TextComponent::content);
    public static final MinecraftHasher<TextComponent> FULL_TEXT_COMPONENT = ComponentHasher.component(builder -> builder.accept("text", MinecraftHasher.STRING, TextComponent::content));
    public static final MinecraftHasher<TextComponent> TEXT_COMPONENT = MinecraftHasher.dispatch(component -> {
        if (component.children().isEmpty() && component.style().isEmpty()) {
            return SIMPLE_TEXT_COMPONENT;
        }
        return FULL_TEXT_COMPONENT;
    });
    public static final MinecraftHasher<TranslatableComponent> TRANSLATABLE_COMPONENT = ComponentHasher.component(builder -> builder.accept("translate", MinecraftHasher.STRING, TranslatableComponent::key).optionalNullable("fallback", MinecraftHasher.STRING, TranslatableComponent::fallback));
    public static final MinecraftHasher<KeybindComponent> KEYBIND_COMPONENT = ComponentHasher.component(builder -> builder.accept("keybind", MinecraftHasher.STRING, component -> component.keybind()));
    public static final MinecraftHasher<ScoreComponent> SCORE_COMPONENT = ComponentHasher.component(builder -> builder.accept("name", MinecraftHasher.STRING, ScoreComponent::name).accept("objective", MinecraftHasher.STRING, ScoreComponent::objective));
    public static final MinecraftHasher<SelectorComponent> SELECTOR_COMPONENT = ComponentHasher.component(builder -> builder.accept("selector", MinecraftHasher.STRING, SelectorComponent::pattern).optionalNullable("separator", COMPONENT, SelectorComponent::separator));
    public static final MinecraftHasher<NBTComponent<?, ?>> NBT_COMPONENT = ComponentHasher.component(builder -> builder.accept("nbt", MinecraftHasher.STRING, NBTComponent::nbtPath).optional("interpret", MinecraftHasher.BOOL, NBTComponent::interpret, false).optionalNullable("separator", COMPONENT, NBTComponent::separator));
    public static final MinecraftHasher<Component> ACTUAL_COMPONENT = (component, encoder) -> {
        if (component instanceof TextComponent) {
            TextComponent text = (TextComponent)component;
            return TEXT_COMPONENT.hash(text, encoder);
        }
        if (component instanceof TranslatableComponent) {
            TranslatableComponent translatable = (TranslatableComponent)component;
            return TRANSLATABLE_COMPONENT.hash(translatable, encoder);
        }
        if (component instanceof KeybindComponent) {
            KeybindComponent keybind = (KeybindComponent)component;
            return KEYBIND_COMPONENT.hash(keybind, encoder);
        }
        if (component instanceof ScoreComponent) {
            ScoreComponent score = (ScoreComponent)component;
            return SCORE_COMPONENT.hash(score, encoder);
        }
        if (component instanceof SelectorComponent) {
            SelectorComponent selector = (SelectorComponent)component;
            return SELECTOR_COMPONENT.hash(selector, encoder);
        }
        if (component instanceof NBTComponent) {
            NBTComponent nbt = (NBTComponent)component;
            return NBT_COMPONENT.hash(nbt, encoder);
        }
        throw new IllegalStateException("Unimplemented component hasher: " + String.valueOf(component));
    };

    private static <T extends Component> MinecraftHasher<T> component(MapBuilder<T> componentBuilder) {
        return MinecraftHasher.mapBuilder(builder -> builder.accept(componentBuilder).accept(STYLE, Component::style).optionalList("extra", COMPONENT, Component::children));
    }
}

