/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.item.Potion;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.PotionContents;

public class ArrowItem
extends Item {
    public ArrowItem(String javaIdentifier, Item.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public @NonNull GeyserItemStack translateToJava(GeyserSession session, @NonNull ItemData itemData, @NonNull ItemMapping mapping, @NonNull ItemMappings mappings) {
        Potion potion = Potion.getByTippedArrowDamage(itemData.getDamage());
        GeyserItemStack itemStack = super.translateToJava(session, itemData, mapping, mappings);
        if (potion != null) {
            itemStack = Items.TIPPED_ARROW.newItemStack(itemStack.getAmount(), itemStack.getComponents());
            PotionContents contents = potion.toComponent();
            itemStack.getOrCreateComponents().put(DataComponentTypes.POTION_CONTENTS, contents);
        }
        return itemStack;
    }

    @Override
    public boolean ignoreDamage() {
        return true;
    }
}

