/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.dialog.input;

import java.util.Optional;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.geysermc.cumulus.form.CustomForm;
import org.geysermc.cumulus.response.CustomFormResponse;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.dialog.input.DialogInput;
import org.geysermc.geyser.session.dialog.input.DialogInputParseException;
import org.geysermc.geyser.util.MinecraftKey;

public class TextInput
extends DialogInput<String> {
    public static final Key TYPE = MinecraftKey.key("text");
    private final boolean labelVisible;
    private final String initial;
    private final int maxLength;

    public TextInput(GeyserSession session, NbtMap map) {
        super(session, map);
        this.labelVisible = map.getBoolean("label_visible", true);
        this.initial = map.getString("initial", "");
        this.maxLength = map.getInt("max_length", 32);
    }

    @Override
    public void addComponent(CustomForm.Builder builder, Optional<String> restored) {
        builder.input(this.labelVisible ? this.label : "", "", restored.orElse(this.initial));
    }

    @Override
    public String read(CustomFormResponse response) throws DialogInputParseException {
        String text = response.asInput();
        assert (text != null);
        if (text.length() > this.maxLength) {
            throw new DialogInputParseException("geyser.dialogs.text_input_limit", text, this.maxLength);
        }
        return text;
    }

    @Override
    public String asSubstitution(String value) {
        return value;
    }

    @Override
    public void addToMap(NbtMapBuilder builder, String value) {
        builder.putString(this.key, value);
    }

    @Override
    public String defaultValue() {
        return this.initial;
    }
}

