/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.key.Key;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.level.waypoint.AzimuthWaypointData;
import org.geysermc.mcprotocollib.protocol.data.game.level.waypoint.ChunkWaypointData;
import org.geysermc.mcprotocollib.protocol.data.game.level.waypoint.TrackedWaypoint;
import org.geysermc.mcprotocollib.protocol.data.game.level.waypoint.Vec3iWaypointData;
import org.geysermc.mcprotocollib.protocol.data.game.level.waypoint.WaypointData;
import org.geysermc.mcprotocollib.protocol.data.game.level.waypoint.WaypointOperation;

public class ClientboundTrackedWaypointPacket
implements MinecraftPacket {
    private WaypointOperation operation;
    private TrackedWaypoint waypoint;

    public ClientboundTrackedWaypointPacket(ByteBuf in) {
        this.operation = WaypointOperation.from(MinecraftTypes.readVarInt(in));
        UUID uuid = null;
        String id = null;
        if (in.readBoolean()) {
            uuid = MinecraftTypes.readUUID(in);
        } else {
            id = MinecraftTypes.readString(in);
        }
        Key style = MinecraftTypes.readResourceLocation(in);
        Optional<Integer> rgbColor = Optional.ofNullable(MinecraftTypes.readNullable(in, buf -> 0xFF000000 | (buf.readByte() & 0xFF) << 16 | (buf.readByte() & 0xFF) << 8 | buf.readByte()));
        TrackedWaypoint.Icon icon = new TrackedWaypoint.Icon(style, rgbColor);
        TrackedWaypoint.Type type = TrackedWaypoint.Type.from(MinecraftTypes.readVarInt(in));
        Record data = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case TrackedWaypoint.Type.EMPTY -> null;
            case TrackedWaypoint.Type.VEC3I -> new Vec3iWaypointData(MinecraftTypes.readVec3i(in));
            case TrackedWaypoint.Type.CHUNK -> new ChunkWaypointData(MinecraftTypes.readVarInt(in), MinecraftTypes.readVarInt(in));
            case TrackedWaypoint.Type.AZIMUTH -> new AzimuthWaypointData(in.readFloat());
        };
        this.waypoint = new TrackedWaypoint(uuid, id, icon, type, (WaypointData)((Object)data));
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.operation.ordinal());
        if (this.waypoint.uuid() != null) {
            out.writeBoolean(true);
            MinecraftTypes.writeUUID(out, this.waypoint.uuid());
        } else {
            out.writeBoolean(false);
            MinecraftTypes.writeString(out, this.waypoint.id());
        }
        MinecraftTypes.writeResourceLocation(out, this.waypoint.icon().style());
        if (this.waypoint.icon().color().isPresent()) {
            out.writeBoolean(true);
            int color = this.waypoint.icon().color().get();
            out.writeByte(color >> 16 & 0xFF);
            out.writeByte(color >> 8 & 0xFF);
            out.writeByte(color & 0xFF);
        } else {
            out.writeBoolean(false);
        }
        MinecraftTypes.writeVarInt(out, this.waypoint.type().ordinal());
        WaypointData waypointData = this.waypoint.data();
        if (waypointData instanceof Vec3iWaypointData) {
            Vec3iWaypointData vec3iData = (Vec3iWaypointData)waypointData;
            MinecraftTypes.writeVec3i(out, vec3iData.vector());
        } else {
            waypointData = this.waypoint.data();
            if (waypointData instanceof ChunkWaypointData) {
                ChunkWaypointData chunkData = (ChunkWaypointData)waypointData;
                MinecraftTypes.writeVarInt(out, chunkData.chunkX());
                MinecraftTypes.writeVarInt(out, chunkData.chunkZ());
            } else {
                waypointData = this.waypoint.data();
                if (waypointData instanceof AzimuthWaypointData) {
                    AzimuthWaypointData azimuthData = (AzimuthWaypointData)waypointData;
                    out.writeFloat(azimuthData.angle());
                }
            }
        }
    }

    public WaypointOperation getOperation() {
        return this.operation;
    }

    public TrackedWaypoint getWaypoint() {
        return this.waypoint;
    }

    public void setOperation(WaypointOperation operation) {
        this.operation = operation;
    }

    public void setWaypoint(TrackedWaypoint waypoint) {
        this.waypoint = waypoint;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundTrackedWaypointPacket)) {
            return false;
        }
        ClientboundTrackedWaypointPacket other = (ClientboundTrackedWaypointPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        WaypointOperation this$operation = this.getOperation();
        WaypointOperation other$operation = other.getOperation();
        if (this$operation == null ? other$operation != null : !((Object)((Object)this$operation)).equals((Object)other$operation)) {
            return false;
        }
        TrackedWaypoint this$waypoint = this.getWaypoint();
        TrackedWaypoint other$waypoint = other.getWaypoint();
        return !(this$waypoint == null ? other$waypoint != null : !((Object)this$waypoint).equals(other$waypoint));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundTrackedWaypointPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WaypointOperation $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : ((Object)((Object)$operation)).hashCode());
        TrackedWaypoint $waypoint = this.getWaypoint();
        result = result * 59 + ($waypoint == null ? 43 : ((Object)$waypoint).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundTrackedWaypointPacket(operation=" + String.valueOf((Object)this.getOperation()) + ", waypoint=" + String.valueOf(this.getWaypoint()) + ")";
    }

    public @NonNull ClientboundTrackedWaypointPacket withOperation(WaypointOperation operation) {
        return this.operation == operation ? this : new ClientboundTrackedWaypointPacket(operation, this.waypoint);
    }

    public @NonNull ClientboundTrackedWaypointPacket withWaypoint(TrackedWaypoint waypoint) {
        return this.waypoint == waypoint ? this : new ClientboundTrackedWaypointPacket(this.operation, waypoint);
    }

    public ClientboundTrackedWaypointPacket(WaypointOperation operation, TrackedWaypoint waypoint) {
        this.operation = operation;
        this.waypoint = waypoint;
    }
}

