/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.entity.attribute;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.key.Key;

public interface AttributeType {
    public Key getIdentifier();

    public int getId();

    public static enum Builtin implements AttributeType
    {
        ARMOR("minecraft:armor", 0.0, 0.0, 30.0),
        ARMOR_TOUGHNESS("minecraft:armor_toughness", 0.0, 0.0, 20.0),
        ATTACK_DAMAGE("minecraft:attack_damage", 2.0, 0.0, 2048.0),
        ATTACK_KNOCKBACK("minecraft:attack_knockback", 0.0, 0.0, 5.0),
        ATTACK_SPEED("minecraft:attack_speed", 4.0, 0.0, 1024.0),
        BLOCK_BREAK_SPEED("minecraft:block_break_speed", 1.0, 0.0, 1024.0),
        BLOCK_INTERACTION_RANGE("minecraft:block_interaction_range", 4.5, 0.0, 64.0),
        BURNING_TIME("minecraft:burning_time", 1.0, 0.0, 1024.0),
        EXPLOSION_KNOCKBACK_RESISTANCE("minecraft:explosion_knockback_resistance", 0.0, 0.0, 1.0),
        ENTITY_INTERACTION_RANGE("minecraft:entity_interaction_range", 3.0, 0.0, 64.0),
        FALL_DAMAGE_MULTIPLIER("minecraft:fall_damage_multiplier", 1.0, 0.0, 100.0),
        FLYING_SPEED("minecraft:flying_speed", 0.4, 0.0, 1024.0),
        FOLLOW_RANGE("minecraft:follow_range", 32.0, 0.0, 2048.0),
        GRAVITY("minecraft:gravity", 0.08, -1.0, 1.0),
        JUMP_STRENGTH("minecraft:jump_strength", 0.42, 0.0, 32.0),
        KNOCKBACK_RESISTANCE("minecraft:knockback_resistance", 0.0, 0.0, 1.0),
        LUCK("minecraft:luck", 0.0, -1024.0, 1024.0),
        MAX_ABSORPTION("minecraft:max_absorption", 0.0, 0.0, 2048.0),
        MAX_HEALTH("minecraft:max_health", 20.0, 1.0, 1024.0),
        MINING_EFFICIENCY("minecraft:mining_efficiency", 0.0, 0.0, 1024.0),
        MOVEMENT_EFFICIENCY("minecraft:movement_efficiency", 0.0, 0.0, 1.0),
        MOVEMENT_SPEED("minecraft:movement_speed", 0.7, 0.0, 1024.0),
        OXYGEN_BONUS("minecraft:oxygen_bonus", 0.0, 0.0, 1024.0),
        SAFE_FALL_DISTANCE("minecraft:safe_fall_distance", 3.0, -1024.0, 1024.0),
        SCALE("minecraft:scale", 1.0, 0.0625, 16.0),
        SNEAKING_SPEED("minecraft:sneaking_speed", 0.3, 0.0, 1.0),
        SPAWN_REINFORCEMENTS("minecraft:spawn_reinforcements", 0.0, 0.0, 1.0),
        STEP_HEIGHT("minecraft:step_height", 0.6, 0.0, 10.0),
        SUBMERGED_MINING_SPEED("minecraft:submerged_mining_speed", 0.2, 0.0, 20.0),
        SWEEPING_DAMAGE_RATIO("minecraft:sweeping_damage_ratio", 0.0, 0.0, 1.0),
        TEMPT_RANGE("minecraft:tempt_range", 10.0, 0.0, 2048.0),
        WATER_MOVEMENT_EFFICIENCY("minecraft:water_movement_efficiency", 0.0, 0.0, 1.0);

        private final Key identifier;
        private final double def;
        private final double min;
        private final double max;
        public static final Int2ObjectMap<AttributeType> BUILTIN;

        private Builtin(String identifier, double def, double min, double max) {
            this.identifier = Key.key(identifier);
            this.def = def;
            this.min = min;
            this.max = max;
        }

        @Override
        public int getId() {
            return this.ordinal();
        }

        public static AttributeType from(int id) {
            return (AttributeType)BUILTIN.get(id);
        }

        @Override
        public Key getIdentifier() {
            return this.identifier;
        }

        public double getDef() {
            return this.def;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        static {
            BUILTIN = new Int2ObjectOpenHashMap<AttributeType>();
            for (Builtin attribute : Builtin.values()) {
                BUILTIN.put(attribute.ordinal(), (AttributeType)attribute);
            }
        }
    }
}

