/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.monster;

import java.util.UUID;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.monster.MonsterEntity;
import org.geysermc.geyser.registry.type.GeyserBedrockBlock;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.SoundEvent;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.LevelSoundEvent2Packet;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.IntEntityMetadata;

public class EndermanEntity
extends MonsterEntity {
    public EndermanEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    public void setCarriedBlock(IntEntityMetadata entityMetadata) {
        GeyserBedrockBlock bedrockBlockId = this.session.getBlockMappings().getBedrockBlock(entityMetadata.getPrimitiveValue());
        this.dirtyMetadata.put(EntityDataTypes.CARRY_BLOCK_STATE, bedrockBlockId);
    }

    public void setScreaming(BooleanEntityMetadata entityMetadata) {
        if (entityMetadata.getPrimitiveValue()) {
            LevelSoundEvent2Packet packet = new LevelSoundEvent2Packet();
            packet.setSound(SoundEvent.STARE);
            packet.setPosition(this.position);
            packet.setExtraData(-1);
            packet.setIdentifier("minecraft:enderman");
            this.session.sendUpstreamPacket(packet);
        }
    }

    public void setAngry(BooleanEntityMetadata entityMetadata) {
        this.setFlag(EntityFlag.ANGRY, entityMetadata.getPrimitiveValue());
    }
}

