/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.loader;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.registry.loader.RegistryLoader;
import org.geysermc.geyser.registry.type.SoundMapping;

public class SoundRegistryLoader
implements RegistryLoader<String, Map<String, SoundMapping>> {
    @Override
    public Map<String, SoundMapping> load(String input) {
        JsonNode soundsTree;
        try (InputStream stream = GeyserImpl.getInstance().getBootstrap().getResourceOrThrow(input);){
            soundsTree = GeyserImpl.JSON_MAPPER.readTree(stream);
        }
        catch (IOException e) {
            throw new AssertionError("Unable to load sound mappings", e);
        }
        HashMap<String, SoundMapping> soundMappings = new HashMap<String, SoundMapping>();
        Iterator soundsIterator = soundsTree.fields();
        while (soundsIterator.hasNext()) {
            Map.Entry next = (Map.Entry)soundsIterator.next();
            JsonNode brMap = (JsonNode)next.getValue();
            String javaSound = (String)next.getKey();
            soundMappings.put(javaSound, new SoundMapping(javaSound, brMap.has("bedrock_mapping") && brMap.get("bedrock_mapping").isTextual() ? brMap.get("bedrock_mapping").asText() : null, brMap.has("playsound_mapping") && brMap.get("playsound_mapping").isTextual() ? brMap.get("playsound_mapping").asText() : null, brMap.has("extra_data") && brMap.get("extra_data").isInt() ? brMap.get("extra_data").asInt() : -1, brMap.has("identifier") && brMap.get("identifier").isTextual() ? brMap.get("identifier").asText() : null, brMap.has("level_event") && brMap.get("level_event").isBoolean() && brMap.get("level_event").asBoolean()));
        }
        return soundMappings;
    }
}

