/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.scoreboard.display.score;

import java.util.Objects;
import org.geysermc.geyser.scoreboard.Objective;
import org.geysermc.geyser.scoreboard.ScoreReference;
import org.geysermc.geyser.scoreboard.Team;
import org.geysermc.geyser.scoreboard.display.score.DisplayScore;
import org.geysermc.geyser.scoreboard.display.slot.DisplaySlot;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.ScoreInfo;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.chat.numbers.FixedFormat;
import org.geysermc.mcprotocollib.protocol.data.game.chat.numbers.NumberFormat;

public final class SidebarDisplayScore
extends DisplayScore {
    private ScoreInfo cachedInfo;
    private Team team;
    private String order;
    private boolean onlyScoreValueChanged;

    public SidebarDisplayScore(DisplaySlot slot, long scoreId, ScoreReference reference) {
        super(slot, scoreId, reference);
        this.team(slot.objective().getScoreboard().getTeamFor(reference.name()));
    }

    @Override
    public boolean shouldUpdate() {
        return super.shouldUpdate() || this.shouldTeamUpdate();
    }

    private boolean shouldTeamUpdate() {
        return this.team != null && this.team.lastUpdate() != this.lastTeamUpdate;
    }

    @Override
    public void update(Objective objective) {
        this.markUpdated();
        Object finalName = this.reference.name();
        String displayName = this.reference.displayName();
        if (displayName != null) {
            finalName = displayName;
        } else if (this.team != null) {
            this.lastTeamUpdate = this.team.lastUpdate();
            finalName = this.team.displayName(this.reference.name());
        }
        NumberFormat numberFormat = this.reference.numberFormat();
        if (numberFormat == null) {
            numberFormat = objective.getNumberFormat();
        }
        if (numberFormat instanceof FixedFormat) {
            FixedFormat fixedFormat = (FixedFormat)numberFormat;
            finalName = (String)finalName + " \u00a7r" + MessageTranslator.convertMessage(fixedFormat.getValue(), objective.getScoreboard().session().locale());
        }
        if (this.order != null) {
            finalName = this.order + "\u00a7r" + (String)finalName;
        }
        if (this.cachedInfo != null) {
            this.onlyScoreValueChanged = ((String)finalName).equals(this.cachedInfo.getName());
        }
        this.cachedInfo = new ScoreInfo(this.id, this.slot.objectiveId(), this.reference.score(), (String)finalName);
    }

    public String order() {
        return this.order;
    }

    public DisplayScore order(String order) {
        if (Objects.equals(this.order, order)) {
            return this;
        }
        this.order = order;
        this.requestUpdate();
        return this;
    }

    public Team team() {
        return this.team;
    }

    public void team(Team team) {
        if (this.team != null && team != null) {
            if (!this.team.equals(team)) {
                this.team = team;
                this.requestUpdate();
            }
            return;
        }
        if (this.team != null || team != null) {
            this.team = team;
            this.requestUpdate();
        }
    }

    private void requestUpdate() {
        this.lastUpdate = 0L;
    }

    public ScoreInfo cachedInfo() {
        return this.cachedInfo;
    }

    public boolean exists() {
        return this.cachedInfo != null;
    }

    public boolean onlyScoreValueChanged() {
        return this.onlyScoreValueChanged;
    }
}

