/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util;

import io.netty.buffer.ByteBuf;
import java.math.BigInteger;

public final class VarInts {
    private static final BigInteger BIG_INTEGER_7F = BigInteger.valueOf(127L);
    private static final BigInteger BIG_INTEGER_80 = BigInteger.valueOf(128L);

    public static void writeInt(ByteBuf buffer, int value) {
        VarInts.encode(buffer, (long)(value << 1 ^ value >> 31) & 0xFFFFFFFFL);
    }

    public static int readInt(ByteBuf buffer) {
        int n = (int)VarInts.decode(buffer, 32);
        return n >>> 1 ^ -(n & 1);
    }

    public static void writeUnsignedInt(ByteBuf buffer, int value) {
        VarInts.encode(buffer, (long)value & 0xFFFFFFFFL);
    }

    public static int readUnsignedInt(ByteBuf buffer) {
        return (int)VarInts.decode(buffer, 32);
    }

    public static void writeLong(ByteBuf buffer, long value) {
        VarInts.encode(buffer, value << 1 ^ value >> 63);
    }

    public static long readLong(ByteBuf buffer) {
        long n = VarInts.decode(buffer, 64);
        return n >>> 1 ^ -(n & 1L);
    }

    public static void writeUnsignedLong(ByteBuf buffer, long value) {
        VarInts.encode(buffer, value);
    }

    public static long readUnsignedLong(ByteBuf buffer) {
        return VarInts.decode(buffer, 64);
    }

    private static void encode(ByteBuf buf, long value) {
        if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
            buf.writeByte((int)((byte)value));
        } else if ((value & 0xFFFFFFFFFFFFC000L) == 0L) {
            int w = (int)((value & 0x7FL | 0x80L) << 8 | value >>> 7);
            buf.writeShort(w);
        } else {
            VarInts.encodeFull(buf, value);
        }
    }

    private static void encodeFull(ByteBuf buf, long value) {
        if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
            buf.writeByte((int)((byte)value));
        } else if ((value & 0xFFFFFFFFFFFFC000L) == 0L) {
            int w = (int)((value & 0x7FL | 0x80L) << 8 | value >>> 7);
            buf.writeShort(w);
        } else if ((value & 0xFFFFFFFFFFE00000L) == 0L) {
            int w = (int)((value & 0x7FL | 0x80L) << 16 | (value >>> 7 & 0x7FL | 0x80L) << 8 | value >>> 14);
            buf.writeMedium(w);
        } else if ((value & 0xFFFFFFFFF0000000L) == 0L) {
            int w = (int)((value & 0x7FL | 0x80L) << 24 | (value >>> 7 & 0x7FL | 0x80L) << 16 | (value >>> 14 & 0x7FL | 0x80L) << 8 | value >>> 21);
            buf.writeInt(w);
        } else if ((value & 0xFFFFFFF800000000L) == 0L) {
            int w = (int)((value & 0x7FL | 0x80L) << 24 | (value >>> 7 & 0x7FL | 0x80L) << 16 | (value >>> 14 & 0x7FL | 0x80L) << 8 | (value >>> 21 & 0x7FL | 0x80L));
            buf.writeInt(w);
            buf.writeByte((int)(value >>> 28));
        } else if ((value & 0xFFFFFC0000000000L) == 0L) {
            int w = (int)((value & 0x7FL | 0x80L) << 24 | (value >>> 7 & 0x7FL | 0x80L) << 16 | (value >>> 14 & 0x7FL | 0x80L) << 8 | (value >>> 21 & 0x7FL | 0x80L));
            int w2 = (int)((value >>> 28 & 0x7FL | 0x80L) << 8 | value >>> 35);
            buf.writeInt(w);
            buf.writeShort(w2);
        } else if ((value & 0xFFFE000000000000L) == 0L) {
            int w = (int)((value & 0x7FL | 0x80L) << 24 | (value >>> 7 & 0x7FL | 0x80L) << 16 | (value >>> 14 & 0x7FL | 0x80L) << 8 | (value >>> 21 & 0x7FL | 0x80L));
            int w2 = (int)((value >>> 28 & 0x7FL | 0x80L) << 16 | (value >>> 35 & 0x7FL | 0x80L) << 8 | value >>> 42);
            buf.writeInt(w);
            buf.writeMedium(w2);
        } else if ((value & 0xFF00000000000000L) == 0L) {
            long w = (value & 0x7FL | 0x80L) << 56 | (value >>> 7 & 0x7FL | 0x80L) << 48 | (value >>> 14 & 0x7FL | 0x80L) << 40 | (value >>> 21 & 0x7FL | 0x80L) << 32 | (value >>> 28 & 0x7FL | 0x80L) << 24 | (value >>> 35 & 0x7FL | 0x80L) << 16 | (value >>> 42 & 0x7FL | 0x80L) << 8 | value >>> 49;
            buf.writeLong(w);
        } else if ((value & Long.MIN_VALUE) == 0L) {
            long w = (value & 0x7FL | 0x80L) << 56 | (value >>> 7 & 0x7FL | 0x80L) << 48 | (value >>> 14 & 0x7FL | 0x80L) << 40 | (value >>> 21 & 0x7FL | 0x80L) << 32 | (value >>> 28 & 0x7FL | 0x80L) << 24 | (value >>> 35 & 0x7FL | 0x80L) << 16 | (value >>> 42 & 0x7FL | 0x80L) << 8 | (value >>> 49 & 0x7FL | 0x80L);
            buf.writeLong(w);
            buf.writeByte((int)((byte)(value >>> 56)));
        } else {
            long w = (value & 0x7FL | 0x80L) << 56 | (value >>> 7 & 0x7FL | 0x80L) << 48 | (value >>> 14 & 0x7FL | 0x80L) << 40 | (value >>> 21 & 0x7FL | 0x80L) << 32 | (value >>> 28 & 0x7FL | 0x80L) << 24 | (value >>> 35 & 0x7FL | 0x80L) << 16 | (value >>> 42 & 0x7FL | 0x80L) << 8 | (value >>> 49 & 0x7FL | 0x80L);
            long w2 = (value >>> 56 & 0x7FL | 0x80L) << 8 | value >>> 63;
            buf.writeLong(w);
            buf.writeShort((int)w2);
        }
    }

    private static long decode(ByteBuf buf, int maxBits) {
        long result = 0L;
        for (int shift = 0; shift < maxBits; shift += 7) {
            byte b = buf.readByte();
            result |= ((long)b & 0x7FL) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new ArithmeticException("VarInt was too large");
    }

    public static void writeUnsignedBigVarInt(ByteBuf buffer, BigInteger value) {
        while (true) {
            BigInteger bits = value.and(BIG_INTEGER_7F);
            if ((value = value.shiftRight(7)).compareTo(BigInteger.ZERO) == 0) {
                buffer.writeByte(bits.intValue());
                return;
            }
            buffer.writeByte(bits.or(BIG_INTEGER_80).intValue());
        }
    }

    public static BigInteger readUnsignedBigVarInt(ByteBuf buffer, int maxBits) {
        BigInteger value = BigInteger.ZERO;
        int shift = 0;
        while (true) {
            if (shift >= maxBits) {
                throw new ArithmeticException("VarInt was too large");
            }
            byte b = buffer.readByte();
            value = value.or(BigInteger.valueOf(b & 0x7F).shiftLeft(shift));
            if ((b & 0x80) == 0) {
                return value;
            }
            shift += 7;
        }
    }

    private VarInts() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

