/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.entity.attribute.Attribute;
import org.geysermc.mcprotocollib.protocol.data.game.entity.attribute.AttributeModifier;
import org.geysermc.mcprotocollib.protocol.data.game.entity.attribute.AttributeType;

public class ClientboundUpdateAttributesPacket
implements MinecraftPacket {
    private final int entityId;
    @lombok.NonNull
    private final List<Attribute> attributes;

    public ClientboundUpdateAttributesPacket(ByteBuf in) {
        this.entityId = MinecraftTypes.readVarInt(in);
        this.attributes = new ArrayList<Attribute>();
        int length = MinecraftTypes.readVarInt(in);
        for (int index = 0; index < length; ++index) {
            int attributeId = MinecraftTypes.readVarInt(in);
            double value = in.readDouble();
            ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>();
            int len = MinecraftTypes.readVarInt(in);
            for (int ind = 0; ind < len; ++ind) {
                modifiers.add(new AttributeModifier(MinecraftTypes.readResourceLocation(in), in.readDouble(), MinecraftTypes.readModifierOperation(in)));
            }
            AttributeType type = (AttributeType)AttributeType.Builtin.BUILTIN.get(attributeId);
            this.attributes.add(new Attribute(type, value, modifiers));
        }
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.entityId);
        MinecraftTypes.writeVarInt(out, this.attributes.size());
        for (Attribute attribute : this.attributes) {
            MinecraftTypes.writeVarInt(out, attribute.getType().getId());
            out.writeDouble(attribute.getValue());
            MinecraftTypes.writeVarInt(out, attribute.getModifiers().size());
            for (AttributeModifier modifier : attribute.getModifiers()) {
                MinecraftTypes.writeResourceLocation(out, modifier.getId());
                out.writeDouble(modifier.getAmount());
                MinecraftTypes.writeModifierOperation(out, modifier.getOperation());
            }
        }
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getEntityId() {
        return this.entityId;
    }

    @lombok.NonNull
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundUpdateAttributesPacket)) {
            return false;
        }
        ClientboundUpdateAttributesPacket other = (ClientboundUpdateAttributesPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        List<Attribute> this$attributes = this.getAttributes();
        List<Attribute> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundUpdateAttributesPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        List<Attribute> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundUpdateAttributesPacket(entityId=" + this.getEntityId() + ", attributes=" + String.valueOf(this.getAttributes()) + ")";
    }

    public @NonNull ClientboundUpdateAttributesPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundUpdateAttributesPacket(entityId, this.attributes);
    }

    public @NonNull ClientboundUpdateAttributesPacket withAttributes(@lombok.NonNull List<Attribute> attributes) {
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        return this.attributes == attributes ? this : new ClientboundUpdateAttributesPacket(this.entityId, attributes);
    }

    public ClientboundUpdateAttributesPacket(int entityId, @lombok.NonNull List<Attribute> attributes) {
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        this.entityId = entityId;
        this.attributes = attributes;
    }
}

