/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.loader;

import com.fasterxml.jackson.databind.JsonNode;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.registry.loader.EffectRegistryLoader;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.SoundEvent;
import org.geysermc.geyser.translator.level.event.LevelEventTranslator;
import org.geysermc.geyser.translator.level.event.PlaySoundEventTranslator;
import org.geysermc.geyser.translator.level.event.SoundEventEventTranslator;
import org.geysermc.geyser.translator.level.event.SoundLevelEventTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.level.event.LevelEventType;

public class SoundEventsRegistryLoader
extends EffectRegistryLoader<Map<org.geysermc.mcprotocollib.protocol.data.game.level.event.LevelEvent, LevelEventTranslator>> {
    @Override
    public Map<org.geysermc.mcprotocollib.protocol.data.game.level.event.LevelEvent, LevelEventTranslator> load(String input) {
        this.loadFile(input);
        Iterator effectsIterator = this.get(input).fields();
        Object2ObjectOpenHashMap soundEffects = new Object2ObjectOpenHashMap();
        while (effectsIterator.hasNext()) {
            Map.Entry entry = (Map.Entry)effectsIterator.next();
            JsonNode node = (JsonNode)entry.getValue();
            try {
                String type = node.get("type").asText();
                LevelEventType javaEffect = null;
                Record transformer = null;
                switch (type) {
                    case "soundLevel": {
                        javaEffect = LevelEventType.valueOf((String)entry.getKey());
                        LevelEvent levelEventType = LevelEvent.valueOf(node.get("name").asText());
                        int data = node.has("data") ? node.get("data").intValue() : 0;
                        transformer = new SoundLevelEventTranslator(levelEventType, data);
                        break;
                    }
                    case "soundEvent": {
                        javaEffect = LevelEventType.valueOf((String)entry.getKey());
                        SoundEvent soundEvent = SoundEvent.valueOf(node.get("name").asText());
                        String identifier = node.has("identifier") ? node.get("identifier").asText() : "";
                        int extraData = node.has("extraData") ? node.get("extraData").intValue() : -1;
                        transformer = new SoundEventEventTranslator(soundEvent, identifier, extraData);
                        break;
                    }
                    case "playSound": {
                        javaEffect = LevelEventType.valueOf((String)entry.getKey());
                        String name = node.get("name").asText();
                        float volume = node.has("volume") ? node.get("volume").floatValue() : 1.0f;
                        boolean pitchSub = node.has("pitch_sub") && node.get("pitch_sub").booleanValue();
                        float pitchMul = node.has("pitch_mul") ? node.get("pitch_mul").floatValue() : 1.0f;
                        float pitchAdd = node.has("pitch_add") ? node.get("pitch_add").floatValue() : 0.0f;
                        boolean relative = !node.has("relative") || node.get("relative").booleanValue();
                        transformer = new PlaySoundEventTranslator(name, volume, pitchSub, pitchMul, pitchAdd, relative);
                    }
                }
                if (javaEffect == null) continue;
                soundEffects.put(javaEffect, transformer);
            }
            catch (Exception e) {
                GeyserImpl.getInstance().getLogger().warning("Failed to map sound effect " + (String)entry.getKey() + " : " + String.valueOf(e));
            }
        }
        return soundEffects;
    }
}

