/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.packet;

import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacketHandler;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacketType;
import org.cloudburstmc.protocol.common.PacketSignal;

public class PlayerInputPacket
implements BedrockPacket {
    private Vector2f inputMotion;
    private boolean jumping;
    private boolean sneaking;

    @Override
    public final PacketSignal handle(BedrockPacketHandler handler) {
        return handler.handle(this);
    }

    @Override
    public BedrockPacketType getPacketType() {
        return BedrockPacketType.PLAYER_INPUT;
    }

    @Override
    public PlayerInputPacket clone() {
        try {
            return (PlayerInputPacket)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Vector2f getInputMotion() {
        return this.inputMotion;
    }

    public boolean isJumping() {
        return this.jumping;
    }

    public boolean isSneaking() {
        return this.sneaking;
    }

    public void setInputMotion(Vector2f inputMotion) {
        this.inputMotion = inputMotion;
    }

    public void setJumping(boolean jumping) {
        this.jumping = jumping;
    }

    public void setSneaking(boolean sneaking) {
        this.sneaking = sneaking;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerInputPacket)) {
            return false;
        }
        PlayerInputPacket other = (PlayerInputPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.jumping != other.jumping) {
            return false;
        }
        if (this.sneaking != other.sneaking) {
            return false;
        }
        Vector2f this$inputMotion = this.inputMotion;
        Vector2f other$inputMotion = other.inputMotion;
        return !(this$inputMotion == null ? other$inputMotion != null : !this$inputMotion.equals(other$inputMotion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlayerInputPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.jumping ? 79 : 97);
        result = result * 59 + (this.sneaking ? 79 : 97);
        Vector2f $inputMotion = this.inputMotion;
        result = result * 59 + ($inputMotion == null ? 43 : $inputMotion.hashCode());
        return result;
    }

    public String toString() {
        return "PlayerInputPacket(inputMotion=" + this.inputMotion + ", jumping=" + this.jumping + ", sneaking=" + this.sneaking + ")";
    }
}

