/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.inventory;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;

public class ClientboundSetCursorItemPacket
implements MinecraftPacket {
    private final ItemStack contents;

    public ClientboundSetCursorItemPacket(ByteBuf in) {
        this.contents = MinecraftTypes.readOptionalItemStack(in);
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeOptionalItemStack(out, this.contents);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public ItemStack getContents() {
        return this.contents;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetCursorItemPacket)) {
            return false;
        }
        ClientboundSetCursorItemPacket other = (ClientboundSetCursorItemPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ItemStack this$contents = this.getContents();
        ItemStack other$contents = other.getContents();
        return !(this$contents == null ? other$contents != null : !((Object)this$contents).equals(other$contents));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundSetCursorItemPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ItemStack $contents = this.getContents();
        result = result * 59 + ($contents == null ? 43 : ((Object)$contents).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundSetCursorItemPacket(contents=" + String.valueOf(this.getContents()) + ")";
    }

    public @NonNull ClientboundSetCursorItemPacket withContents(ItemStack contents) {
        return this.contents == contents ? this : new ClientboundSetCursorItemPacket(contents);
    }

    public ClientboundSetCursorItemPacket(ItemStack contents) {
        this.contents = contents;
    }
}

