/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import java.util.OptionalInt;
import java.util.UUID;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.SetEntityMotionPacket;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.item.BedrockItemBuilder;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;

public class FireworkEntity
extends Entity {
    public FireworkEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    public void setFireworkItem(EntityMetadata<ItemStack, ?> entityMetadata) {
        ItemStack item = (ItemStack)entityMetadata.getValue();
        if (item == null) {
            return;
        }
        DataComponents components = item.getDataComponentsPatch();
        if (components == null) {
            return;
        }
        BedrockItemBuilder builder = new BedrockItemBuilder();
        Items.FIREWORK_ROCKET.translateComponentsToBedrock(this.session, components, builder);
        this.dirtyMetadata.put(EntityDataTypes.DISPLAY_FIREWORK, builder.build());
    }

    public void setPlayerGliding(EntityMetadata<OptionalInt, ?> entityMetadata) {
        OptionalInt optional = (OptionalInt)entityMetadata.getValue();
        if (optional.isPresent() && optional.getAsInt() == this.session.getPlayerEntity().getEntityId()) {
            SessionPlayerEntity entity = this.session.getPlayerEntity();
            float yaw = entity.getYaw();
            float pitch = entity.getPitch();
            entity.setMotion(Vector3f.from((double)(-Math.sin(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch)) * 2.0), (double)(-Math.sin(Math.toRadians(pitch)) * 2.0), (double)(Math.cos(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch)) * 2.0)));
            SetEntityMotionPacket entityMotionPacket = new SetEntityMotionPacket();
            entityMotionPacket.setRuntimeEntityId(entity.getGeyserId());
            entityMotionPacket.setMotion(entity.getMotion());
            this.session.sendUpstreamPacket((BedrockPacket)entityMotionPacket);
        }
    }
}

