/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal;

import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.animal.CowEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ObjectEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;

public class MooshroomEntity
extends CowEntity {
    private boolean isBrown = false;

    public MooshroomEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    public void setVariant(ObjectEntityMetadata<String> entityMetadata) {
        this.isBrown = ((String)entityMetadata.getValue()).equals("brown");
        this.dirtyMetadata.put(EntityDataTypes.VARIANT, this.isBrown ? 1 : 0);
    }

    @Override
    protected @NonNull InteractiveTag testMobInteraction(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (!this.isBaby()) {
            if (itemInHand.asItem() == Items.BOWL) {
                return InteractiveTag.MOOSHROOM_MILK_STEW;
            }
            if (this.isAlive() && itemInHand.asItem() == Items.SHEARS) {
                return InteractiveTag.MOOSHROOM_SHEAR;
            }
        }
        return super.testMobInteraction(hand, itemInHand);
    }

    @Override
    protected @NonNull InteractionResult mobInteract(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        boolean isBaby = this.isBaby();
        if (!isBaby && itemInHand.asItem() == Items.BOWL) {
            return InteractionResult.SUCCESS;
        }
        if (!isBaby && this.isAlive() && itemInHand.asItem() == Items.SHEARS) {
            return InteractionResult.SUCCESS;
        }
        if (this.isBrown && this.session.getTagCache().is(ItemTag.SMALL_FLOWERS, itemInHand)) {
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(hand, itemInHand);
    }
}

