/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory.item;

import java.util.Locale;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.registry.JavaRegistry;
import org.geysermc.geyser.session.cache.registry.RegistryEntryContext;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.geyser.util.MinecraftKey;
import org.geysermc.geyser.util.SoundUtils;
import org.geysermc.mcprotocollib.protocol.data.game.Holder;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Instrument;
import org.geysermc.mcprotocollib.protocol.data.game.level.sound.BuiltinSound;

public interface GeyserInstrument {
    public static GeyserInstrument read(RegistryEntryContext context) {
        NbtMap data = context.data();
        String soundEvent = SoundUtils.readSoundEvent(data, "instrument " + String.valueOf(context.id()));
        float range = data.getFloat("range");
        String description = MessageTranslator.deserializeDescriptionForTooltip(context.session(), data);
        BedrockInstrument bedrockInstrument = BedrockInstrument.getByJavaIdentifier(context.id());
        return new Impl(soundEvent, range, description, bedrockInstrument);
    }

    public String soundEvent();

    public float range();

    public String description();

    public BedrockInstrument bedrockInstrument();

    default public int bedrockId() {
        BedrockInstrument bedrockInstrument = this.bedrockInstrument();
        if (bedrockInstrument != null) {
            return bedrockInstrument.ordinal();
        }
        return -1;
    }

    public static int bedrockIdToJava(GeyserSession session, int id) {
        JavaRegistry<GeyserInstrument> instruments = session.getRegistryCache().instruments();
        BedrockInstrument bedrockInstrument = BedrockInstrument.getByBedrockId(id);
        if (bedrockInstrument != null) {
            for (int i = 0; i < instruments.values().size(); ++i) {
                GeyserInstrument instrument = instruments.byId(i);
                if (instrument.bedrockInstrument() != bedrockInstrument) continue;
                return i;
            }
        }
        return -1;
    }

    public static GeyserInstrument fromHolder(GeyserSession session, Holder<Instrument> holder) {
        if (holder.isId()) {
            return session.getRegistryCache().instruments().byId(holder.id());
        }
        Instrument custom = (Instrument)holder.custom();
        return new Wrapper(custom, session.locale());
    }

    public static enum BedrockInstrument {
        PONDER,
        SING,
        SEEK,
        FEEL,
        ADMIRE,
        CALL,
        YEARN,
        DREAM;

        private static final BedrockInstrument[] VALUES;
        private final Key javaIdentifier = MinecraftKey.key(this.name().toLowerCase(Locale.ENGLISH) + "_goat_horn");

        public static @Nullable BedrockInstrument getByJavaIdentifier(Key javaIdentifier) {
            for (BedrockInstrument instrument : VALUES) {
                if (!instrument.javaIdentifier.equals(javaIdentifier)) continue;
                return instrument;
            }
            return null;
        }

        public static @Nullable BedrockInstrument getByBedrockId(int bedrockId) {
            if (bedrockId >= 0 && bedrockId < VALUES.length) {
                return VALUES[bedrockId];
            }
            return null;
        }

        static {
            VALUES = BedrockInstrument.values();
        }
    }

    public record Impl(String soundEvent, float range, String description, @Nullable BedrockInstrument bedrockInstrument) implements GeyserInstrument
    {
    }

    public record Wrapper(Instrument instrument, String locale) implements GeyserInstrument
    {
        @Override
        public String soundEvent() {
            return this.instrument.getSoundEvent().getName();
        }

        @Override
        public float range() {
            return this.instrument.getRange();
        }

        @Override
        public String description() {
            return MessageTranslator.convertMessageForTooltip(this.instrument.getDescription(), this.locale);
        }

        @Override
        public BedrockInstrument bedrockInstrument() {
            if (this.instrument.getSoundEvent() instanceof BuiltinSound) {
                return BedrockInstrument.getByJavaIdentifier(MinecraftKey.key(this.instrument.getSoundEvent().getName()));
            }
            return null;
        }
    }
}

