/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.level;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import org.geysermc.geyser.level.chunk.BlockStorage;
import org.geysermc.geyser.level.chunk.bitarray.BitArray;
import org.geysermc.geyser.level.chunk.bitarray.BitArrayVersion;
import org.geysermc.geyser.level.chunk.bitarray.SingletonBitArray;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.protocol.data.game.RegistryEntry;
import org.geysermc.mcprotocollib.protocol.data.game.chunk.BitStorage;
import org.geysermc.mcprotocollib.protocol.data.game.chunk.DataPalette;
import org.geysermc.mcprotocollib.protocol.data.game.chunk.palette.GlobalPalette;
import org.geysermc.mcprotocollib.protocol.data.game.chunk.palette.Palette;
import org.geysermc.mcprotocollib.protocol.data.game.chunk.palette.SingletonPalette;

public class BiomeTranslator {
    public static int loadServerBiome(RegistryEntry entry) {
        String javaIdentifier = entry.getId().asString();
        return ((Object2IntMap)Registries.BIOME_IDENTIFIERS.get()).getOrDefault((Object)javaIdentifier, 0);
    }

    public static BlockStorage toNewBedrockBiome(GeyserSession session, DataPalette biomeData) {
        BlockStorage storage;
        int[] biomeTranslations = session.getRegistryCache().biomeTranslations();
        Palette palette = biomeData.getPalette();
        if (palette instanceof SingletonPalette) {
            int biomeId = biomeTranslations[palette.idToState(0)];
            return new BlockStorage(SingletonBitArray.INSTANCE, IntLists.singleton((int)biomeId));
        }
        if (!(palette instanceof GlobalPalette)) {
            int i;
            BitStorage bitStorage = biomeData.getStorage();
            int size = palette.size();
            BitArray bitArray = BitArrayVersion.forBitsCeil(bitStorage.getBitsPerEntry()).createArray(4096);
            IntArrayList bedrockPalette = new IntArrayList(size);
            for (i = 0; i < size; ++i) {
                int javaId = palette.idToState(i);
                bedrockPalette.add(biomeTranslations[javaId]);
            }
            for (i = 0; i < 64; ++i) {
                int idx = bitStorage.get(i);
                int x = i & 3;
                int y = i >> 4 & 3;
                int z = i >> 2 & 3;
                BiomeTranslator.multiplyIdToStorage(bitArray, idx, x, y, z);
            }
            storage = new BlockStorage(bitArray, (IntList)bedrockPalette);
        } else {
            storage = new BlockStorage(0);
            for (int i = 0; i < 64; ++i) {
                int javaId = palette.idToState(biomeData.getStorage().get(i));
                int x = i & 3;
                int y = i >> 4 & 3;
                int z = i >> 2 & 3;
                int biomeId = biomeTranslations[javaId];
                int idx = storage.idFor(biomeId);
                BiomeTranslator.multiplyIdToStorage(storage.getBitArray(), idx, x, y, z);
            }
        }
        return storage;
    }

    private static void multiplyIdToStorage(BitArray bitArray, int idx, int x, int y, int z) {
        for (int blockX = x << 2; blockX < (x << 2) + 4; ++blockX) {
            for (int blockZ = z << 2; blockZ < (z << 2) + 4; ++blockZ) {
                for (int blockY = y << 2; blockY < (y << 2) + 4; ++blockY) {
                    bitArray.set(blockX << 8 | blockZ << 4 | blockY, idx);
                }
            }
        }
    }
}

