/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.IntFunction;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.packet.InventorySlotPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.Container;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.LecternContainer;
import org.geysermc.geyser.inventory.click.Click;
import org.geysermc.geyser.inventory.recipe.GeyserRecipe;
import org.geysermc.geyser.inventory.recipe.GeyserShapedRecipe;
import org.geysermc.geyser.inventory.recipe.GeyserShapelessRecipe;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.level.BedrockDimension;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.geyser.session.cache.tags.Tag;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.geyser.translator.inventory.LecternInventoryTranslator;
import org.geysermc.geyser.translator.inventory.chest.DoubleChestInventoryTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.slot.CompositeSlotDisplay;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.slot.EmptySlotDisplay;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.slot.ItemSlotDisplay;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.slot.ItemStackSlotDisplay;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.slot.SlotDisplay;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.slot.TagSlotDisplay;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.slot.WithRemainderSlotDisplay;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundContainerClosePacket;
import org.jetbrains.annotations.Contract;

public class InventoryUtils {
    public static int LAST_RECIPE_NET_ID;
    public static final ItemStack REFRESH_ITEM;

    public static void openInventory(GeyserSession session, Inventory inventory) {
        session.setOpenInventory(inventory);
        if (session.isClosingInventory() || !session.getUpstream().isInitialized()) {
            inventory.setPending(true);
            return;
        }
        InventoryUtils.displayInventory(session, inventory);
    }

    public static void displayInventory(GeyserSession session, Inventory inventory) {
        InventoryTranslator translator = session.getInventoryTranslator();
        if (translator.prepareInventory(session, inventory)) {
            if (translator instanceof DoubleChestInventoryTranslator && !((Container)inventory).isUsingRealBlock()) {
                session.scheduleInEventLoop(() -> {
                    Inventory openInv = session.getOpenInventory();
                    if (openInv != null && openInv.getJavaId() == inventory.getJavaId()) {
                        translator.openInventory(session, inventory);
                        translator.updateInventory(session, inventory);
                        openInv.setDisplayed(true);
                    } else if (openInv != null && openInv.isPending()) {
                        InventoryUtils.displayInventory(session, openInv);
                    }
                }, 200L, TimeUnit.MILLISECONDS);
            } else {
                translator.openInventory(session, inventory);
                translator.updateInventory(session, inventory);
                inventory.setDisplayed(true);
            }
        } else {
            InventoryUtils.sendJavaContainerClose(session, inventory);
            session.setOpenInventory(null);
            session.setInventoryTranslator(InventoryTranslator.PLAYER_INVENTORY_TRANSLATOR);
        }
    }

    public static void closeInventory(GeyserSession session, int javaId, boolean confirm) {
        session.getPlayerInventory().setCursor(GeyserItemStack.EMPTY, session);
        InventoryUtils.updateCursor(session);
        Inventory inventory = InventoryUtils.getInventory(session, javaId);
        if (inventory != null) {
            InventoryTranslator translator = session.getInventoryTranslator();
            translator.closeInventory(session, inventory);
            if (confirm && inventory.isDisplayed() && !inventory.isPending() && !(translator instanceof LecternInventoryTranslator)) {
                session.setClosingInventory(true);
            }
            session.getBundleCache().onInventoryClose(inventory);
        }
        session.setInventoryTranslator(InventoryTranslator.PLAYER_INVENTORY_TRANSLATOR);
        session.setOpenInventory(null);
    }

    public static @Nullable Inventory getInventory(GeyserSession session, int javaId) {
        if (javaId == 0) {
            if (session.getOpenInventory() instanceof LecternContainer) {
                return session.getOpenInventory();
            }
            return session.getPlayerInventory();
        }
        Inventory openInventory = session.getOpenInventory();
        if (openInventory != null && javaId == openInventory.getJavaId()) {
            return openInventory;
        }
        return null;
    }

    public static void sendJavaContainerClose(GeyserSession session, Inventory inventory) {
        if (inventory.shouldConfirmContainerClose()) {
            ServerboundContainerClosePacket closeWindowPacket = new ServerboundContainerClosePacket(inventory.getJavaId());
            session.sendDownstreamGamePacket(closeWindowPacket);
        }
    }

    public static @Nullable Vector3i findAvailableWorldSpace(GeyserSession session) {
        BedrockDimension dimension = session.getBedrockDimension();
        int minY = dimension.minY();
        int maxY = minY + dimension.height();
        Vector3i flatPlayerPosition = session.getPlayerEntity().getPosition().toInt();
        Vector3i position = flatPlayerPosition.add(Vector3i.UP);
        if (position.getY() < minY) {
            return null;
        }
        if (!(position.getY() < maxY && InventoryUtils.canUseWorldSpace(session, position) || (position = flatPlayerPosition.sub(0, 4, 0)).getY() < maxY && InventoryUtils.canUseWorldSpace(session, position))) {
            return null;
        }
        return position;
    }

    private static boolean canUseWorldSpace(GeyserSession session, Vector3i position) {
        BlockState state = session.getGeyser().getWorldManager().blockAt(session, position);
        return state.block().blockEntityType() == null;
    }

    public static void updateCursor(GeyserSession session) {
        InventorySlotPacket cursorPacket = new InventorySlotPacket();
        cursorPacket.setContainerId(124);
        cursorPacket.setSlot(0);
        cursorPacket.setItem(session.getPlayerInventory().getCursor().getItemData(session));
        session.sendUpstreamPacket(cursorPacket);
    }

    public static boolean canStack(GeyserItemStack item1, GeyserItemStack item2) {
        if (GeyserImpl.getInstance().getConfig().isDebugMode()) {
            InventoryUtils.canStackDebug(item1, item2);
        }
        if (item1.isEmpty() || item2.isEmpty()) {
            return false;
        }
        return item1.getJavaId() == item2.getJavaId() && Objects.equals(item1.getComponents(), item2.getComponents());
    }

    private static void canStackDebug(GeyserItemStack item1, GeyserItemStack item2) {
        DataComponents components1 = item1.getComponents();
        DataComponents components2 = item2.getComponents();
        if (components1 != null && components2 != null && components1.hashCode() == components2.hashCode() && !components1.equals(components2)) {
            GeyserImpl.getInstance().getLogger().error("DEBUG: DataComponents hash collision");
            GeyserImpl.getInstance().getLogger().error("hash: " + components1.hashCode());
            GeyserImpl.getInstance().getLogger().error("components1: " + String.valueOf(components1));
            GeyserImpl.getInstance().getLogger().error("components2: " + String.valueOf(components2));
        }
    }

    @Contract(value="null -> true")
    public static boolean isEmpty(@Nullable ItemStack itemStack) {
        return itemStack == null || itemStack.getId() == Items.AIR_ID || itemStack.getAmount() <= 0;
    }

    public static IntFunction<ItemData> createUnusableSpaceBlock(String description) {
        NbtMapBuilder root = NbtMap.builder();
        NbtMapBuilder display = NbtMap.builder();
        display.putString("Name", "\u00a7r" + GeyserLocale.getLocaleStringLog("geyser.inventory.unusable_item.name"));
        display.putList("Lore", NbtType.STRING, Collections.singletonList("\u00a7r\u00a75" + description));
        root.put("display", (Object)display.build());
        return protocolVersion -> ItemData.builder().definition(InventoryUtils.getUnusableSpaceBlockDefinition(protocolVersion)).count(1).tag(root.build()).build();
    }

    private static ItemDefinition getUnusableSpaceBlockDefinition(int protocolVersion) {
        String unusableSpaceBlock;
        ItemMappings mappings = Registries.ITEMS.forVersion(protocolVersion);
        ItemDefinition itemDefinition = mappings.getDefinition(unusableSpaceBlock = GeyserImpl.getInstance().getConfig().getUnusableSpaceBlock());
        if (itemDefinition == null) {
            GeyserImpl.getInstance().getLogger().error("Invalid value " + unusableSpaceBlock + ". Resorting to barrier block.");
            return mappings.getStoredItems().barrier().getBedrockDefinition();
        }
        return itemDefinition;
    }

    public static IntFunction<ItemData> getUpgradeTemplate() {
        return protocolVersion -> ItemData.builder().definition(Registries.ITEMS.forVersion(protocolVersion).getStoredItems().upgradeTemplate().getBedrockDefinition()).count(1).build();
    }

    public static IntFunction<ItemData> getTotemOfUndying() {
        return protocolVersion -> ItemData.builder().definition(Registries.ITEMS.forVersion(protocolVersion).getStoredItems().totem().getBedrockDefinition()).count(1).build();
    }

    public static @Nullable Click getClickForHotbarSwap(int slot) {
        return switch (slot) {
            case 0 -> Click.SWAP_TO_HOTBAR_1;
            case 1 -> Click.SWAP_TO_HOTBAR_2;
            case 2 -> Click.SWAP_TO_HOTBAR_3;
            case 3 -> Click.SWAP_TO_HOTBAR_4;
            case 4 -> Click.SWAP_TO_HOTBAR_5;
            case 5 -> Click.SWAP_TO_HOTBAR_6;
            case 6 -> Click.SWAP_TO_HOTBAR_7;
            case 7 -> Click.SWAP_TO_HOTBAR_8;
            case 8 -> Click.SWAP_TO_HOTBAR_9;
            default -> null;
        };
    }

    public static boolean acceptsAsInput(GeyserSession session, SlotDisplay slotDisplay, GeyserItemStack itemStack) {
        if (slotDisplay instanceof EmptySlotDisplay) {
            return itemStack.isEmpty();
        }
        if (slotDisplay instanceof CompositeSlotDisplay) {
            CompositeSlotDisplay compositeSlotDisplay = (CompositeSlotDisplay)slotDisplay;
            if (compositeSlotDisplay.contents().size() == 1) {
                return InventoryUtils.acceptsAsInput(session, compositeSlotDisplay.contents().get(0), itemStack);
            }
            return compositeSlotDisplay.contents().stream().anyMatch(aSlotDisplay -> InventoryUtils.acceptsAsInput(session, aSlotDisplay, itemStack));
        }
        if (slotDisplay instanceof WithRemainderSlotDisplay) {
            WithRemainderSlotDisplay remainderSlotDisplay = (WithRemainderSlotDisplay)slotDisplay;
            return InventoryUtils.acceptsAsInput(session, remainderSlotDisplay.input(), itemStack);
        }
        if (slotDisplay instanceof ItemSlotDisplay) {
            ItemSlotDisplay itemSlotDisplay = (ItemSlotDisplay)slotDisplay;
            return itemStack.getJavaId() == itemSlotDisplay.item();
        }
        if (slotDisplay instanceof ItemStackSlotDisplay) {
            ItemStackSlotDisplay itemStackSlotDisplay = (ItemStackSlotDisplay)slotDisplay;
            ItemStack other = itemStackSlotDisplay.itemStack();
            return itemStack.getJavaId() == other.getId() && itemStack.getAmount() >= other.getAmount() && Objects.equals(itemStack.getComponents(), other.getDataComponentsPatch());
        }
        if (slotDisplay instanceof TagSlotDisplay) {
            TagSlotDisplay tagSlotDisplay = (TagSlotDisplay)slotDisplay;
            return session.getTagCache().is(new Tag<Item>(JavaRegistries.ITEM, tagSlotDisplay.tag()), itemStack.asItem());
        }
        session.getGeyser().getLogger().warning("Unknown slot display type: " + String.valueOf(slotDisplay));
        return false;
    }

    public static @Nullable GeyserRecipe getValidRecipe(GeyserSession session, @Nullable ItemStack output, IntFunction<GeyserItemStack> inventoryGetter, int gridDimensions, int firstRow, int height, int firstCol, int width) {
        int nonAirCount = 0;
        for (int row = firstRow; row < height + firstRow; ++row) {
            for (int col = firstCol; col < width + firstCol; ++col) {
                if (inventoryGetter.apply(col + row * gridDimensions + 1).isEmpty()) continue;
                ++nonAirCount;
            }
        }
        block2: for (GeyserRecipe recipe : session.getCraftingRecipes().values()) {
            if (recipe.isShaped()) {
                GeyserShapedRecipe shapedRecipe = (GeyserShapedRecipe)recipe;
                if (output != null && !InventoryUtils.acceptsAsInput(session, shapedRecipe.result(), GeyserItemStack.from(output))) continue;
                List<SlotDisplay> ingredients = shapedRecipe.ingredients();
                if (shapedRecipe.width() != width || shapedRecipe.height() != height || width * height != ingredients.size()) continue;
                if (!InventoryUtils.testShapedRecipe(session, ingredients, inventoryGetter, gridDimensions, firstRow, height, firstCol, width)) {
                    ArrayList<SlotDisplay> mirroredIngredients = new ArrayList<SlotDisplay>(ingredients.size());
                    for (int row = 0; row < height; ++row) {
                        for (int col = 0; col < width; ++col) {
                            int index = col + row * width;
                            while (mirroredIngredients.size() <= index) {
                                mirroredIngredients.add(null);
                            }
                            mirroredIngredients.set(index, ingredients.get(width - 1 - col + row * width));
                        }
                    }
                    if (ingredients.equals(mirroredIngredients) || !InventoryUtils.testShapedRecipe(session, mirroredIngredients, inventoryGetter, gridDimensions, firstRow, height, firstCol, width)) {
                        continue;
                    }
                }
            } else {
                GeyserShapelessRecipe data = (GeyserShapelessRecipe)recipe;
                if (output != null && !InventoryUtils.acceptsAsInput(session, data.result(), GeyserItemStack.from(output)) || nonAirCount != data.ingredients().size()) continue;
                for (int i = 0; i < data.ingredients().size(); ++i) {
                    SlotDisplay slotDisplay = data.ingredients().get(i);
                    boolean inventoryHasItem = false;
                    block7: for (int row = firstRow; row < height + firstRow; ++row) {
                        for (int col = firstCol; col < width + firstCol; ++col) {
                            GeyserItemStack geyserItemStack = inventoryGetter.apply(col + row * gridDimensions + 1);
                            if (!InventoryUtils.acceptsAsInput(session, slotDisplay, geyserItemStack)) continue;
                            inventoryHasItem = true;
                            continue block7;
                        }
                    }
                    if (!inventoryHasItem) continue block2;
                }
            }
            return recipe;
        }
        return null;
    }

    private static boolean testShapedRecipe(GeyserSession session, List<SlotDisplay> ingredients, IntFunction<GeyserItemStack> inventoryGetter, int gridDimensions, int firstRow, int height, int firstCol, int width) {
        int ingredientIndex = 0;
        for (int row = firstRow; row < height + firstRow; ++row) {
            for (int col = firstCol; col < width + firstCol; ++col) {
                SlotDisplay slotDisplay;
                GeyserItemStack geyserItemStack = inventoryGetter.apply(col + row * gridDimensions + 1);
                if (InventoryUtils.acceptsAsInput(session, slotDisplay = ingredients.get(ingredientIndex++), geyserItemStack)) continue;
                return false;
            }
        }
        return true;
    }

    static {
        REFRESH_ITEM = new ItemStack(1, 127, new DataComponents(new HashMap()));
    }
}

