/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import java.util.UUID;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.packet.AnimatePacket;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.FloatEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundSwingPacket;

public class InteractionEntity
extends Entity {
    private boolean response = false;

    public InteractionEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    @Override
    protected void initializeMetadata() {
        super.initializeMetadata();
        this.setFlag(EntityFlag.INVISIBLE, true);
    }

    @Override
    public InteractionResult interact(Hand hand) {
        if (this.response) {
            AnimatePacket animatePacket = new AnimatePacket();
            animatePacket.setRuntimeEntityId(this.session.getPlayerEntity().getGeyserId());
            animatePacket.setAction(AnimatePacket.Action.SWING_ARM);
            this.session.sendUpstreamPacket((BedrockPacket)animatePacket);
            this.session.sendDownstreamGamePacket((Packet)new ServerboundSwingPacket(hand));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    public void setWidth(FloatEntityMetadata width) {
        this.setBoundingBoxWidth(width.getPrimitiveValue());
    }

    public void setHeight(FloatEntityMetadata height) {
        this.setBoundingBoxHeight(Math.min(height.getPrimitiveValue(), 64.0f));
    }

    public void setResponse(BooleanEntityMetadata response) {
        this.response = response.getPrimitiveValue();
    }
}

