/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.level;

import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.cloudburstmc.protocol.bedrock.data.LevelEventType;
import org.cloudburstmc.protocol.bedrock.data.ParticleType;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.LevelEventGenericPacket;
import org.cloudburstmc.protocol.bedrock.packet.LevelEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.SpawnParticleEffectPacket;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.ParticleMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.item.ItemTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.DimensionUtils;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.level.particle.BlockParticleData;
import org.geysermc.mcprotocollib.protocol.data.game.level.particle.DustParticleData;
import org.geysermc.mcprotocollib.protocol.data.game.level.particle.ItemParticleData;
import org.geysermc.mcprotocollib.protocol.data.game.level.particle.Particle;
import org.geysermc.mcprotocollib.protocol.data.game.level.particle.VibrationParticleData;
import org.geysermc.mcprotocollib.protocol.data.game.level.particle.positionsource.BlockPositionSource;
import org.geysermc.mcprotocollib.protocol.data.game.level.particle.positionsource.EntityPositionSource;
import org.geysermc.mcprotocollib.protocol.data.game.level.particle.positionsource.PositionSource;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level.ClientboundLevelParticlesPacket;

@Translator(packet=ClientboundLevelParticlesPacket.class)
public class JavaLevelParticlesTranslator
extends PacketTranslator<ClientboundLevelParticlesPacket> {
    private static final int MAX_PARTICLES = 100;

    @Override
    public void translate(GeyserSession session, ClientboundLevelParticlesPacket packet) {
        Function<Vector3f, BedrockPacket> particleCreateFunction = JavaLevelParticlesTranslator.createParticle(session, packet.getParticle());
        if (particleCreateFunction != null) {
            if (packet.getAmount() == 0) {
                Vector3f position = Vector3f.from((double)packet.getX(), (double)packet.getY(), (double)packet.getZ());
                session.sendUpstreamPacket(particleCreateFunction.apply(position));
            } else {
                ThreadLocalRandom random = ThreadLocalRandom.current();
                int amount = Math.min(100, packet.getAmount());
                for (int i = 0; i < amount; ++i) {
                    double offsetX = random.nextGaussian() * (double)packet.getOffsetX();
                    double offsetY = random.nextGaussian() * (double)packet.getOffsetY();
                    double offsetZ = random.nextGaussian() * (double)packet.getOffsetZ();
                    Vector3f position = Vector3f.from((double)(packet.getX() + offsetX), (double)(packet.getY() + offsetY), (double)(packet.getZ() + offsetZ));
                    session.sendUpstreamPacket(particleCreateFunction.apply(position));
                }
            }
        } else {
            session.getGeyser().getLogger().debug("Unhandled particle packet: " + String.valueOf(packet));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static @Nullable Function<Vector3f, BedrockPacket> createParticle(GeyserSession session, Particle particle) {
        switch (particle.getType()) {
            case BLOCK: {
                int blockState = session.getBlockMappings().getBedrockBlockId(((BlockParticleData)particle.getData()).getBlockState());
                return position -> {
                    LevelEventPacket packet = new LevelEventPacket();
                    packet.setType((LevelEventType)LevelEvent.PARTICLE_CRACK_BLOCK);
                    packet.setPosition(position);
                    packet.setData(blockState);
                    return packet;
                };
            }
            case FALLING_DUST: {
                int blockState = session.getBlockMappings().getBedrockBlockId(((BlockParticleData)particle.getData()).getBlockState());
                return position -> {
                    LevelEventPacket packet = new LevelEventPacket();
                    packet.setType((LevelEventType)ParticleType.FALLING_DUST);
                    packet.setData(blockState);
                    packet.setPosition(position);
                    return packet;
                };
            }
            case ITEM: {
                ItemStack javaItem = ((ItemParticleData)particle.getData()).getItemStack();
                ItemData bedrockItem = ItemTranslator.translateToBedrock(session, javaItem);
                int data = bedrockItem.getDefinition().getRuntimeId() << 16 | bedrockItem.getDamage();
                return position -> {
                    LevelEventPacket packet = new LevelEventPacket();
                    packet.setType((LevelEventType)ParticleType.ICON_CRACK);
                    packet.setData(data);
                    packet.setPosition(position);
                    return packet;
                };
            }
            case DUST: 
            case DUST_COLOR_TRANSITION: {
                DustParticleData data = (DustParticleData)particle.getData();
                int rgbData = data.getColor();
                return position -> {
                    LevelEventPacket packet = new LevelEventPacket();
                    packet.setType((LevelEventType)ParticleType.FALLING_DUST);
                    packet.setData(rgbData);
                    packet.setPosition(position);
                    return packet;
                };
            }
            case VIBRATION: {
                Vector3f target;
                VibrationParticleData data = (VibrationParticleData)particle.getData();
                PositionSource positionSource = data.getPositionSource();
                if (positionSource instanceof BlockPositionSource) {
                    BlockPositionSource blockPositionSource = (BlockPositionSource)positionSource;
                    target = blockPositionSource.getPosition().toFloat().add(0.5f, 0.5f, 0.5f);
                    return position -> {
                        LevelEventGenericPacket packet = new LevelEventGenericPacket();
                        packet.setType((LevelEventType)LevelEvent.PARTICLE_VIBRATION_SIGNAL);
                        packet.setTag((Object)NbtMap.builder().putCompound("origin", JavaLevelParticlesTranslator.buildVec3PositionTag(position)).putCompound("target", JavaLevelParticlesTranslator.buildVec3PositionTag(target)).putFloat("speed", 20.0f).putFloat("timeToLive", (float)data.getArrivalTicks() / 20.0f).build());
                        return packet;
                    };
                }
                positionSource = data.getPositionSource();
                if (!(positionSource instanceof EntityPositionSource)) {
                    session.getGeyser().getLogger().debug("Unknown position source " + String.valueOf(data.getPositionSource()) + " for vibration particle.");
                    return null;
                }
                EntityPositionSource entityPositionSource = (EntityPositionSource)positionSource;
                Entity entity = session.getEntityCache().getEntityByJavaId(entityPositionSource.getEntityId());
                if (entity != null) {
                    target = entity.getPosition().up(entityPositionSource.getYOffset());
                    return position -> {
                        LevelEventGenericPacket packet = new LevelEventGenericPacket();
                        packet.setType((LevelEventType)LevelEvent.PARTICLE_VIBRATION_SIGNAL);
                        packet.setTag((Object)NbtMap.builder().putCompound("origin", JavaLevelParticlesTranslator.buildVec3PositionTag(position)).putCompound("target", JavaLevelParticlesTranslator.buildVec3PositionTag(target)).putFloat("speed", 20.0f).putFloat("timeToLive", (float)data.getArrivalTicks() / 20.0f).build());
                        return packet;
                    };
                }
                session.getGeyser().getLogger().debug("Unable to find entity with Java Id: " + entityPositionSource.getEntityId() + " for vibration particle.");
                return null;
            }
        }
        ParticleMapping particleMapping = (ParticleMapping)Registries.PARTICLES.get(particle.getType());
        if (particleMapping == null) {
            return null;
        }
        if (particleMapping.levelEventType() != null) {
            return position -> {
                LevelEventPacket packet = new LevelEventPacket();
                packet.setType(particleMapping.levelEventType());
                packet.setPosition(position);
                return packet;
            };
        }
        if (particleMapping.identifier() == null) return null;
        int dimensionId = DimensionUtils.javaToBedrock(session);
        return position -> {
            SpawnParticleEffectPacket stringPacket = new SpawnParticleEffectPacket();
            stringPacket.setIdentifier(particleMapping.identifier());
            stringPacket.setDimensionId(dimensionId);
            stringPacket.setPosition(position);
            stringPacket.setMolangVariablesJson(Optional.empty());
            return stringPacket;
        };
    }

    private static NbtMap buildVec3PositionTag(Vector3f position) {
        return NbtMap.builder().putString("type", "vec3").putFloat("x", position.getX()).putFloat("y", position.getY()).putFloat("z", position.getZ()).build();
    }
}

