/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.UpdateStructureBlockAction;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.UpdateStructureBlockMode;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.StructureMirror;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.StructureRotation;

public class ServerboundSetStructureBlockPacket
implements MinecraftPacket {
    private static final int FLAG_IGNORE_ENTITIES = 1;
    private static final int FLAG_SHOW_AIR = 2;
    private static final int FLAG_SHOW_BOUNDING_BOX = 4;
    private static final int FLAG_STRICT = 8;
    @lombok.NonNull
    private final Vector3i position;
    @lombok.NonNull
    private final UpdateStructureBlockAction action;
    @lombok.NonNull
    private final UpdateStructureBlockMode mode;
    @lombok.NonNull
    private final String name;
    @lombok.NonNull
    private final Vector3i offset;
    @lombok.NonNull
    private final Vector3i size;
    @lombok.NonNull
    private final StructureMirror mirror;
    @lombok.NonNull
    private final StructureRotation rotation;
    @lombok.NonNull
    private final String metadata;
    private final float integrity;
    private final long seed;
    private final boolean ignoreEntities;
    private final boolean showAir;
    private final boolean showBoundingBox;
    private final boolean strict;

    public ServerboundSetStructureBlockPacket(ByteBuf in) {
        this.position = MinecraftTypes.readPosition(in);
        this.action = UpdateStructureBlockAction.from(MinecraftTypes.readVarInt(in));
        this.mode = UpdateStructureBlockMode.from(MinecraftTypes.readVarInt(in));
        this.name = MinecraftTypes.readString(in);
        this.offset = Vector3i.from(in.readByte(), in.readByte(), in.readByte());
        this.size = Vector3i.from(in.readUnsignedByte(), in.readUnsignedByte(), in.readUnsignedByte());
        this.mirror = StructureMirror.from(MinecraftTypes.readVarInt(in));
        this.rotation = StructureRotation.from(MinecraftTypes.readVarInt(in));
        this.metadata = MinecraftTypes.readString(in);
        this.integrity = in.readFloat();
        this.seed = MinecraftTypes.readVarLong(in);
        short flags = in.readUnsignedByte();
        this.ignoreEntities = (flags & 1) != 0;
        this.showAir = (flags & 2) != 0;
        this.showBoundingBox = (flags & 4) != 0;
        this.strict = (flags & 8) != 0;
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writePosition(out, this.position);
        MinecraftTypes.writeVarInt(out, this.action.ordinal());
        MinecraftTypes.writeVarInt(out, this.mode.ordinal());
        MinecraftTypes.writeString(out, this.name);
        out.writeByte(this.offset.getX());
        out.writeByte(this.offset.getY());
        out.writeByte(this.offset.getZ());
        out.writeByte(this.size.getX());
        out.writeByte(this.size.getY());
        out.writeByte(this.size.getZ());
        MinecraftTypes.writeVarInt(out, this.mirror.ordinal());
        MinecraftTypes.writeVarInt(out, this.rotation.ordinal());
        MinecraftTypes.writeString(out, this.metadata);
        out.writeFloat(this.integrity);
        MinecraftTypes.writeVarLong(out, this.seed);
        int flags = 0;
        if (this.ignoreEntities) {
            flags |= 1;
        }
        if (this.showAir) {
            flags |= 2;
        }
        if (this.showBoundingBox) {
            flags |= 4;
        }
        if (this.strict) {
            flags |= 8;
        }
        out.writeByte(flags);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    @lombok.NonNull
    public Vector3i getPosition() {
        return this.position;
    }

    @lombok.NonNull
    public UpdateStructureBlockAction getAction() {
        return this.action;
    }

    @lombok.NonNull
    public UpdateStructureBlockMode getMode() {
        return this.mode;
    }

    @lombok.NonNull
    public String getName() {
        return this.name;
    }

    @lombok.NonNull
    public Vector3i getOffset() {
        return this.offset;
    }

    @lombok.NonNull
    public Vector3i getSize() {
        return this.size;
    }

    @lombok.NonNull
    public StructureMirror getMirror() {
        return this.mirror;
    }

    @lombok.NonNull
    public StructureRotation getRotation() {
        return this.rotation;
    }

    @lombok.NonNull
    public String getMetadata() {
        return this.metadata;
    }

    public float getIntegrity() {
        return this.integrity;
    }

    public long getSeed() {
        return this.seed;
    }

    public boolean isIgnoreEntities() {
        return this.ignoreEntities;
    }

    public boolean isShowAir() {
        return this.showAir;
    }

    public boolean isShowBoundingBox() {
        return this.showBoundingBox;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundSetStructureBlockPacket)) {
            return false;
        }
        ServerboundSetStructureBlockPacket other = (ServerboundSetStructureBlockPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getIntegrity(), other.getIntegrity()) != 0) {
            return false;
        }
        if (this.getSeed() != other.getSeed()) {
            return false;
        }
        if (this.isIgnoreEntities() != other.isIgnoreEntities()) {
            return false;
        }
        if (this.isShowAir() != other.isShowAir()) {
            return false;
        }
        if (this.isShowBoundingBox() != other.isShowBoundingBox()) {
            return false;
        }
        if (this.isStrict() != other.isStrict()) {
            return false;
        }
        Vector3i this$position = this.getPosition();
        Vector3i other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        UpdateStructureBlockAction this$action = this.getAction();
        UpdateStructureBlockAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        UpdateStructureBlockMode this$mode = this.getMode();
        UpdateStructureBlockMode other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Vector3i this$offset = this.getOffset();
        Vector3i other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !this$offset.equals(other$offset)) {
            return false;
        }
        Vector3i this$size = this.getSize();
        Vector3i other$size = other.getSize();
        if (this$size == null ? other$size != null : !this$size.equals(other$size)) {
            return false;
        }
        StructureMirror this$mirror = this.getMirror();
        StructureMirror other$mirror = other.getMirror();
        if (this$mirror == null ? other$mirror != null : !((Object)((Object)this$mirror)).equals((Object)other$mirror)) {
            return false;
        }
        StructureRotation this$rotation = this.getRotation();
        StructureRotation other$rotation = other.getRotation();
        if (this$rotation == null ? other$rotation != null : !((Object)((Object)this$rotation)).equals((Object)other$rotation)) {
            return false;
        }
        String this$metadata = this.getMetadata();
        String other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundSetStructureBlockPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getIntegrity());
        long $seed = this.getSeed();
        result = result * 59 + (int)($seed >>> 32 ^ $seed);
        result = result * 59 + (this.isIgnoreEntities() ? 79 : 97);
        result = result * 59 + (this.isShowAir() ? 79 : 97);
        result = result * 59 + (this.isShowBoundingBox() ? 79 : 97);
        result = result * 59 + (this.isStrict() ? 79 : 97);
        Vector3i $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        UpdateStructureBlockAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        UpdateStructureBlockMode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Vector3i $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : $offset.hashCode());
        Vector3i $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : $size.hashCode());
        StructureMirror $mirror = this.getMirror();
        result = result * 59 + ($mirror == null ? 43 : ((Object)((Object)$mirror)).hashCode());
        StructureRotation $rotation = this.getRotation();
        result = result * 59 + ($rotation == null ? 43 : ((Object)((Object)$rotation)).hashCode());
        String $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundSetStructureBlockPacket(position=" + String.valueOf(this.getPosition()) + ", action=" + String.valueOf((Object)this.getAction()) + ", mode=" + String.valueOf((Object)this.getMode()) + ", name=" + this.getName() + ", offset=" + String.valueOf(this.getOffset()) + ", size=" + String.valueOf(this.getSize()) + ", mirror=" + String.valueOf((Object)this.getMirror()) + ", rotation=" + String.valueOf((Object)this.getRotation()) + ", metadata=" + this.getMetadata() + ", integrity=" + this.getIntegrity() + ", seed=" + this.getSeed() + ", ignoreEntities=" + this.isIgnoreEntities() + ", showAir=" + this.isShowAir() + ", showBoundingBox=" + this.isShowBoundingBox() + ", strict=" + this.isStrict() + ")";
    }

    public @NonNull ServerboundSetStructureBlockPacket withPosition(@lombok.NonNull Vector3i position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ServerboundSetStructureBlockPacket(position, this.action, this.mode, this.name, this.offset, this.size, this.mirror, this.rotation, this.metadata, this.integrity, this.seed, this.ignoreEntities, this.showAir, this.showBoundingBox, this.strict);
    }

    public @NonNull ServerboundSetStructureBlockPacket withAction(@lombok.NonNull UpdateStructureBlockAction action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        return this.action == action ? this : new ServerboundSetStructureBlockPacket(this.position, action, this.mode, this.name, this.offset, this.size, this.mirror, this.rotation, this.metadata, this.integrity, this.seed, this.ignoreEntities, this.showAir, this.showBoundingBox, this.strict);
    }

    public @NonNull ServerboundSetStructureBlockPacket withMode(@lombok.NonNull UpdateStructureBlockMode mode) {
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        return this.mode == mode ? this : new ServerboundSetStructureBlockPacket(this.position, this.action, mode, this.name, this.offset, this.size, this.mirror, this.rotation, this.metadata, this.integrity, this.seed, this.ignoreEntities, this.showAir, this.showBoundingBox, this.strict);
    }

    public @NonNull ServerboundSetStructureBlockPacket withName(@lombok.NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.name == name ? this : new ServerboundSetStructureBlockPacket(this.position, this.action, this.mode, name, this.offset, this.size, this.mirror, this.rotation, this.metadata, this.integrity, this.seed, this.ignoreEntities, this.showAir, this.showBoundingBox, this.strict);
    }

    public @NonNull ServerboundSetStructureBlockPacket withOffset(@lombok.NonNull Vector3i offset) {
        if (offset == null) {
            throw new NullPointerException("offset is marked non-null but is null");
        }
        return this.offset == offset ? this : new ServerboundSetStructureBlockPacket(this.position, this.action, this.mode, this.name, offset, this.size, this.mirror, this.rotation, this.metadata, this.integrity, this.seed, this.ignoreEntities, this.showAir, this.showBoundingBox, this.strict);
    }

    public @NonNull ServerboundSetStructureBlockPacket withSize(@lombok.NonNull Vector3i size) {
        if (size == null) {
            throw new NullPointerException("size is marked non-null but is null");
        }
        return this.size == size ? this : new ServerboundSetStructureBlockPacket(this.position, this.action, this.mode, this.name, this.offset, size, this.mirror, this.rotation, this.metadata, this.integrity, this.seed, this.ignoreEntities, this.showAir, this.showBoundingBox, this.strict);
    }

    public @NonNull ServerboundSetStructureBlockPacket withMirror(@lombok.NonNull StructureMirror mirror) {
        if (mirror == null) {
            throw new NullPointerException("mirror is marked non-null but is null");
        }
        return this.mirror == mirror ? this : new ServerboundSetStructureBlockPacket(this.position, this.action, this.mode, this.name, this.offset, this.size, mirror, this.rotation, this.metadata, this.integrity, this.seed, this.ignoreEntities, this.showAir, this.showBoundingBox, this.strict);
    }

    public @NonNull ServerboundSetStructureBlockPacket withRotation(@lombok.NonNull StructureRotation rotation) {
        if (rotation == null) {
            throw new NullPointerException("rotation is marked non-null but is null");
        }
        return this.rotation == rotation ? this : new ServerboundSetStructureBlockPacket(this.position, this.action, this.mode, this.name, this.offset, this.size, this.mirror, rotation, this.metadata, this.integrity, this.seed, this.ignoreEntities, this.showAir, this.showBoundingBox, this.strict);
    }

    public @NonNull ServerboundSetStructureBlockPacket withMetadata(@lombok.NonNull String metadata) {
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        return this.metadata == metadata ? this : new ServerboundSetStructureBlockPacket(this.position, this.action, this.mode, this.name, this.offset, this.size, this.mirror, this.rotation, metadata, this.integrity, this.seed, this.ignoreEntities, this.showAir, this.showBoundingBox, this.strict);
    }

    public @NonNull ServerboundSetStructureBlockPacket withIntegrity(float integrity) {
        return this.integrity == integrity ? this : new ServerboundSetStructureBlockPacket(this.position, this.action, this.mode, this.name, this.offset, this.size, this.mirror, this.rotation, this.metadata, integrity, this.seed, this.ignoreEntities, this.showAir, this.showBoundingBox, this.strict);
    }

    public @NonNull ServerboundSetStructureBlockPacket withSeed(long seed) {
        return this.seed == seed ? this : new ServerboundSetStructureBlockPacket(this.position, this.action, this.mode, this.name, this.offset, this.size, this.mirror, this.rotation, this.metadata, this.integrity, seed, this.ignoreEntities, this.showAir, this.showBoundingBox, this.strict);
    }

    public @NonNull ServerboundSetStructureBlockPacket withIgnoreEntities(boolean ignoreEntities) {
        return this.ignoreEntities == ignoreEntities ? this : new ServerboundSetStructureBlockPacket(this.position, this.action, this.mode, this.name, this.offset, this.size, this.mirror, this.rotation, this.metadata, this.integrity, this.seed, ignoreEntities, this.showAir, this.showBoundingBox, this.strict);
    }

    public @NonNull ServerboundSetStructureBlockPacket withShowAir(boolean showAir) {
        return this.showAir == showAir ? this : new ServerboundSetStructureBlockPacket(this.position, this.action, this.mode, this.name, this.offset, this.size, this.mirror, this.rotation, this.metadata, this.integrity, this.seed, this.ignoreEntities, showAir, this.showBoundingBox, this.strict);
    }

    public @NonNull ServerboundSetStructureBlockPacket withShowBoundingBox(boolean showBoundingBox) {
        return this.showBoundingBox == showBoundingBox ? this : new ServerboundSetStructureBlockPacket(this.position, this.action, this.mode, this.name, this.offset, this.size, this.mirror, this.rotation, this.metadata, this.integrity, this.seed, this.ignoreEntities, this.showAir, showBoundingBox, this.strict);
    }

    public @NonNull ServerboundSetStructureBlockPacket withStrict(boolean strict) {
        return this.strict == strict ? this : new ServerboundSetStructureBlockPacket(this.position, this.action, this.mode, this.name, this.offset, this.size, this.mirror, this.rotation, this.metadata, this.integrity, this.seed, this.ignoreEntities, this.showAir, this.showBoundingBox, strict);
    }

    public ServerboundSetStructureBlockPacket(@lombok.NonNull Vector3i position, @lombok.NonNull UpdateStructureBlockAction action, @lombok.NonNull UpdateStructureBlockMode mode, @lombok.NonNull String name, @lombok.NonNull Vector3i offset, @lombok.NonNull Vector3i size, @lombok.NonNull StructureMirror mirror, @lombok.NonNull StructureRotation rotation, @lombok.NonNull String metadata, float integrity, long seed, boolean ignoreEntities, boolean showAir, boolean showBoundingBox, boolean strict) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (offset == null) {
            throw new NullPointerException("offset is marked non-null but is null");
        }
        if (size == null) {
            throw new NullPointerException("size is marked non-null but is null");
        }
        if (mirror == null) {
            throw new NullPointerException("mirror is marked non-null but is null");
        }
        if (rotation == null) {
            throw new NullPointerException("rotation is marked non-null but is null");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        this.position = position;
        this.action = action;
        this.mode = mode;
        this.name = name;
        this.offset = offset;
        this.size = size;
        this.mirror = mirror;
        this.rotation = rotation;
        this.metadata = metadata;
        this.integrity = integrity;
        this.seed = seed;
        this.ignoreEntities = ignoreEntities;
        this.showAir = showAir;
        this.showBoundingBox = showBoundingBox;
        this.strict = strict;
    }
}

