/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache.waypoint;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.awt.Color;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.UUID;
import org.cloudburstmc.protocol.bedrock.packet.PlayerListPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayerLocationPacket;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.waypoint.GeyserWaypoint;
import org.geysermc.geyser.session.cache.waypoint.TickingWaypoint;
import org.geysermc.geyser.skin.SkinManager;
import org.geysermc.mcprotocollib.protocol.data.game.level.waypoint.TrackedWaypoint;
import org.geysermc.mcprotocollib.protocol.data.game.level.waypoint.WaypointOperation;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level.ClientboundTrackedWaypointPacket;

public final class WaypointCache {
    private final GeyserSession session;
    private final Map<String, GeyserWaypoint> waypoints = new Object2ObjectOpenHashMap<String, GeyserWaypoint>();
    private final Map<UUID, Color> waypointColors = new Object2ObjectOpenHashMap<UUID, Color>();

    public WaypointCache(GeyserSession session) {
        this.session = session;
    }

    public void handlePacket(ClientboundTrackedWaypointPacket packet) {
        switch (packet.getOperation()) {
            case TRACK: {
                this.track(packet.getWaypoint());
                break;
            }
            case UNTRACK: {
                this.untrack(packet.getWaypoint());
                break;
            }
            case UPDATE: {
                this.update(packet.getWaypoint());
            }
        }
        if (packet.getOperation() == WaypointOperation.TRACK || packet.getOperation() == WaypointOperation.UNTRACK) {
            this.session.sendGameRule("locatorBar", !this.waypoints.isEmpty());
        }
    }

    public void listPlayer(PlayerEntity player) {
        GeyserWaypoint waypoint = this.waypoints.get(player.getUuid().toString());
        if (waypoint != null) {
            waypoint.setPlayer(player);
        } else {
            PlayerLocationPacket locationPacket = new PlayerLocationPacket();
            locationPacket.setType(PlayerLocationPacket.Type.HIDE);
            locationPacket.setTargetEntityId(player.getGeyserId());
            this.session.sendUpstreamPacket(locationPacket);
        }
    }

    public void unlistPlayer(PlayerEntity player) {
        GeyserWaypoint waypoint = this.waypoints.get(player.getUuid().toString());
        if (waypoint != null) {
            waypoint.setPlayer(null);
        }
    }

    public Optional<Color> getWaypointColor(UUID uuid) {
        return Optional.ofNullable(this.waypointColors.get(uuid));
    }

    public void tick() {
        for (GeyserWaypoint waypoint : this.waypoints.values()) {
            if (!(waypoint instanceof TickingWaypoint)) continue;
            TickingWaypoint ticking = (TickingWaypoint)((Object)waypoint);
            ticking.tick();
        }
    }

    private void track(TrackedWaypoint waypoint) {
        this.untrack(waypoint);
        Optional<UUID> uuid = Optional.ofNullable(waypoint.uuid());
        Optional player = uuid.flatMap(id -> Optional.ofNullable(this.session.getEntityCache().getPlayerEntity((UUID)id)));
        OptionalLong playerId = player.stream().mapToLong(Entity::getGeyserId).findFirst();
        GeyserWaypoint tracked = GeyserWaypoint.create(this.session, uuid, playerId, waypoint);
        if (tracked != null) {
            uuid.ifPresent(id -> this.waypointColors.put((UUID)id, tracked.color()));
            player.ifPresent(this::updatePlayerEntry);
            tracked.track(waypoint.data());
            this.waypoints.put(WaypointCache.waypointId(waypoint), tracked);
        } else {
            playerId.ifPresent(id -> {
                PlayerLocationPacket locationPacket = new PlayerLocationPacket();
                locationPacket.setType(PlayerLocationPacket.Type.HIDE);
                locationPacket.setTargetEntityId(id);
                this.session.sendUpstreamPacket(locationPacket);
            });
        }
    }

    private void update(TrackedWaypoint waypoint) {
        this.getWaypoint(waypoint).ifPresent(tracked -> tracked.update(waypoint.data()));
    }

    private void untrack(TrackedWaypoint waypoint) {
        this.getWaypoint(waypoint).ifPresent(GeyserWaypoint::untrack);
        this.waypoints.remove(WaypointCache.waypointId(waypoint));
        this.waypointColors.remove(waypoint.uuid());
    }

    private Optional<GeyserWaypoint> getWaypoint(TrackedWaypoint waypoint) {
        return Optional.ofNullable(this.waypoints.get(WaypointCache.waypointId(waypoint)));
    }

    private static String waypointId(TrackedWaypoint waypoint) {
        return Optional.ofNullable(waypoint.uuid()).map(UUID::toString).orElse(waypoint.id());
    }

    private void updatePlayerEntry(PlayerEntity player) {
        if (!player.isListed()) {
            return;
        }
        PlayerListPacket.Entry entry = SkinManager.buildCachedEntry(this.session, player);
        PlayerListPacket removePacket = new PlayerListPacket();
        removePacket.setAction(PlayerListPacket.Action.REMOVE);
        removePacket.getEntries().add(entry);
        this.session.sendUpstreamPacket(removePacket);
        PlayerListPacket addPacket = new PlayerListPacket();
        addPacket.setAction(PlayerListPacket.Action.ADD);
        addPacket.getEntries().add(entry);
        this.session.sendUpstreamPacket(addPacket);
    }

    public void clear() {
        this.waypoints.clear();
        this.session.sendGameRule("locatorBar", false);
    }
}

