/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory.chest;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.BlockEntityDataPacket;
import org.cloudburstmc.protocol.bedrock.packet.ContainerClosePacket;
import org.cloudburstmc.protocol.bedrock.packet.ContainerOpenPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateBlockPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.Container;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.property.ChestType;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.physics.Direction;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.type.GeyserBedrockBlock;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.chest.ChestInventoryTranslator;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;
import org.geysermc.geyser.translator.level.block.entity.DoubleChestBlockEntityTranslator;
import org.geysermc.geyser.util.InventoryUtils;

public class DoubleChestInventoryTranslator
extends ChestInventoryTranslator {
    private final int defaultJavaBlockState = Blocks.CHEST.defaultBlockState().withValue(Properties.HORIZONTAL_FACING, Direction.NORTH).withValue(Properties.CHEST_TYPE, ChestType.SINGLE).javaId();

    public DoubleChestInventoryTranslator(int size) {
        super(size, 54);
    }

    @Override
    public boolean canReuseInventory(GeyserSession session, @NonNull Inventory inventory, @NonNull Inventory oldInventory) {
        block6: {
            block5: {
                if (!super.canReuseInventory(session, inventory, oldInventory) || !(inventory instanceof Container)) break block5;
                Container container = (Container)inventory;
                if (oldInventory instanceof Container) break block6;
            }
            return false;
        }
        Container previous = (Container)oldInventory;
        if (previous.isUsingRealBlock()) {
            return false;
        }
        Vector3i position = InventoryUtils.findAvailableWorldSpace(session);
        if (Objects.equals(position, previous.getHolderPosition())) {
            return true;
        }
        GeyserImpl.getInstance().getLogger().debug(session, "Not reusing inventory (%s) due to virtual block holder changing (%s -> %s)!", InventoryUtils.debugInventory(inventory), previous.getHolderPosition(), position);
        return false;
    }

    @Override
    public boolean prepareInventory(GeyserSession session, Inventory inventory) {
        if (this.canUseRealBlock(session, inventory)) {
            return true;
        }
        Vector3i position = InventoryUtils.findAvailableWorldSpace(session);
        if (position == null) {
            return false;
        }
        Vector3i pairPosition = position.add(Vector3i.UNIT_X);
        GeyserBedrockBlock definition = session.getBlockMappings().getVanillaBedrockBlock(this.defaultJavaBlockState);
        UpdateBlockPacket blockPacket = new UpdateBlockPacket();
        blockPacket.setDataLayer(0);
        blockPacket.setBlockPosition(position);
        blockPacket.setDefinition((BlockDefinition)definition);
        blockPacket.getFlags().addAll(UpdateBlockPacket.FLAG_ALL_PRIORITY);
        session.sendUpstreamPacket((BedrockPacket)blockPacket);
        NbtMapBuilder tag = BlockEntityTranslator.getConstantBedrockTag("Chest", position).putInt("pairx", pairPosition.getX()).putInt("pairz", pairPosition.getZ()).putString("CustomName", inventory.getTitle()).putBoolean("pairlead", false);
        BlockEntityDataPacket dataPacket = new BlockEntityDataPacket();
        dataPacket.setData(tag.build());
        dataPacket.setBlockPosition(position);
        session.sendUpstreamPacket((BedrockPacket)dataPacket);
        blockPacket = new UpdateBlockPacket();
        blockPacket.setDataLayer(0);
        blockPacket.setBlockPosition(pairPosition);
        blockPacket.setDefinition((BlockDefinition)definition);
        blockPacket.getFlags().addAll(UpdateBlockPacket.FLAG_ALL_PRIORITY);
        session.sendUpstreamPacket((BedrockPacket)blockPacket);
        tag = NbtMap.builder().putString("id", "Chest").putInt("x", pairPosition.getX()).putInt("y", pairPosition.getY()).putInt("z", pairPosition.getZ()).putInt("pairx", position.getX()).putInt("pairz", position.getZ()).putString("CustomName", inventory.getTitle()).putBoolean("pairlead", true);
        dataPacket = new BlockEntityDataPacket();
        dataPacket.setData(tag.build());
        dataPacket.setBlockPosition(pairPosition);
        session.sendUpstreamPacket((BedrockPacket)dataPacket);
        inventory.setHolderPosition(position);
        return true;
    }

    @Override
    public void openInventory(GeyserSession session, Inventory inventory) {
        ContainerOpenPacket containerOpenPacket = new ContainerOpenPacket();
        containerOpenPacket.setId((byte)inventory.getBedrockId());
        containerOpenPacket.setType(ContainerType.CONTAINER);
        containerOpenPacket.setBlockPosition(inventory.getHolderPosition());
        containerOpenPacket.setUniqueEntityId(inventory.getHolderId());
        session.sendUpstreamPacket((BedrockPacket)containerOpenPacket);
        GeyserImpl.getInstance().getLogger().debug(session, containerOpenPacket.toString(), new Object[0]);
    }

    @Override
    public void closeInventory(GeyserSession session, Inventory inventory) {
        if (!(inventory instanceof Container)) {
            GeyserImpl.getInstance().getLogger().warning("Tried to close a non-container inventory in a block inventory holder! Please report this error on discord.");
            GeyserImpl.getInstance().getLogger().warning("Current inventory translator: " + InventoryUtils.getInventoryTranslator(session).getClass().getSimpleName());
            GeyserImpl.getInstance().getLogger().warning("Current inventory: " + inventory.getClass().getSimpleName());
            if (session.getOpenInventory() != null) {
                session.getOpenInventory().getTranslator().closeInventory(session, inventory);
                session.setOpenInventory(null);
            }
            return;
        }
        Container container = (Container)inventory;
        if (container.isDisplayed()) {
            ContainerClosePacket packet = new ContainerClosePacket();
            packet.setId((byte)inventory.getBedrockId());
            packet.setServerInitiated(true);
            packet.setType(ContainerType.CONTAINER);
            session.sendUpstreamPacket((BedrockPacket)packet);
        }
        if (!container.isUsingRealBlock()) {
            Vector3i holderPos = inventory.getHolderPosition();
            int realBlock = session.getGeyser().getWorldManager().getBlockAt(session, holderPos);
            UpdateBlockPacket blockPacket = new UpdateBlockPacket();
            blockPacket.setDataLayer(0);
            blockPacket.setBlockPosition(holderPos);
            blockPacket.setDefinition((BlockDefinition)session.getBlockMappings().getBedrockBlock(realBlock));
            session.sendUpstreamPacket((BedrockPacket)blockPacket);
            holderPos = holderPos.add(Vector3i.UNIT_X);
            realBlock = session.getGeyser().getWorldManager().getBlockAt(session, holderPos);
            blockPacket = new UpdateBlockPacket();
            blockPacket.setDataLayer(0);
            blockPacket.setBlockPosition(holderPos);
            blockPacket.setDefinition((BlockDefinition)session.getBlockMappings().getBedrockBlock(realBlock));
            session.sendUpstreamPacket((BedrockPacket)blockPacket);
        }
    }

    private boolean canUseRealBlock(GeyserSession session, Inventory inventory) {
        if (session.getLastInteractionPlayerPosition().equals(session.getPlayerEntity().getPosition())) {
            BlockState state = session.getGeyser().getWorldManager().blockAt(session, session.getLastInteractionBlockPosition());
            if (!(((Int2ObjectMap)BlockRegistries.CUSTOM_BLOCK_STATE_OVERRIDES.get()).containsKey(state.javaId()) || state.block() != Blocks.CHEST && state.block() != Blocks.TRAPPED_CHEST || state.getValue(Properties.CHEST_TYPE) == ChestType.SINGLE)) {
                inventory.setHolderPosition(session.getLastInteractionBlockPosition());
                ((Container)inventory).setUsingRealBlock(true, state.block());
                NbtMapBuilder tag = BlockEntityTranslator.getConstantBedrockTag("Chest", session.getLastInteractionBlockPosition()).putString("CustomName", inventory.getTitle());
                DoubleChestBlockEntityTranslator.translateChestValue(tag, state, session.getLastInteractionBlockPosition().getX(), session.getLastInteractionBlockPosition().getZ());
                BlockEntityDataPacket dataPacket = new BlockEntityDataPacket();
                dataPacket.setData(tag.build());
                dataPacket.setBlockPosition(session.getLastInteractionBlockPosition());
                session.sendUpstreamPacket((BedrockPacket)dataPacket);
                return true;
            }
        }
        return false;
    }
}

