/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.inventory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.RecipeUnlockingRequirement;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.ShapedRecipeData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.SmithingTransformRecipeData;
import org.cloudburstmc.protocol.bedrock.data.inventory.descriptor.ItemDescriptorWithCount;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.CraftingDataPacket;
import org.cloudburstmc.protocol.bedrock.packet.InventorySlotPacket;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.recipe.GeyserShapedRecipe;
import org.geysermc.geyser.inventory.recipe.GeyserSmithingRecipe;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.geyser.translator.inventory.PlayerInventoryTranslator;
import org.geysermc.geyser.translator.inventory.SmithingInventoryTranslator;
import org.geysermc.geyser.translator.item.ItemTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.slot.ItemStackSlotDisplay;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.slot.SlotDisplay;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.inventory.ClientboundContainerSetSlotPacket;

@Translator(packet=ClientboundContainerSetSlotPacket.class)
public class JavaContainerSetSlotTranslator
extends PacketTranslator<ClientboundContainerSetSlotPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundContainerSetSlotPacket packet) {
        Inventory inventory = InventoryUtils.getInventory(session, packet.getContainerId());
        if (inventory == null) {
            return;
        }
        InventoryTranslator translator = InventoryUtils.getInventoryTranslator(session);
        if (translator != null) {
            int slot = packet.getSlot();
            if (slot >= inventory.getSize()) {
                GeyserLogger logger = session.getGeyser().getLogger();
                logger.warning("ClientboundContainerSetSlotPacket sent to " + session.bedrockUsername() + " that exceeds inventory size!");
                if (logger.isDebug()) {
                    logger.debug(packet.toString());
                    logger.debug(inventory.toString());
                }
                return;
            }
            if (translator instanceof SmithingInventoryTranslator) {
                JavaContainerSetSlotTranslator.updateSmithingTableOutput(session, slot, packet.getItem(), inventory);
            } else {
                JavaContainerSetSlotTranslator.updateCraftingGrid(session, slot, packet.getItem(), inventory, translator);
            }
            GeyserItemStack newItem = GeyserItemStack.from(packet.getItem());
            session.getBundleCache().initialize(newItem);
            if (packet.getContainerId() == 0 && !(translator instanceof PlayerInventoryTranslator)) {
                session.getPlayerInventory().setItem(slot, newItem, session);
                InventoryTranslator.PLAYER_INVENTORY_TRANSLATOR.updateSlot(session, session.getPlayerInventory(), slot);
            } else {
                inventory.setItem(slot, newItem, session);
                translator.updateSlot(session, inventory, slot);
            }
            int stateId = packet.getStateId();
            session.setEmulatePost1_16Logic(stateId > 0 || stateId != inventory.getStateId());
            inventory.setStateId(stateId);
        }
    }

    private static void updateCraftingGrid(GeyserSession session, int slot, ItemStack item, Inventory inventory, InventoryTranslator translator) {
        if (slot != 0) {
            return;
        }
        int gridSize = translator.getGridSize();
        if (gridSize == -1) {
            return;
        }
        if (session.getContainerOutputFuture() != null) {
            session.getContainerOutputFuture().cancel(false);
        }
        if (InventoryUtils.isEmpty(item)) {
            return;
        }
        session.setContainerOutputFuture(session.scheduleInEventLoop(() -> {
            InventorySlotPacket slotPacket;
            int offset = gridSize == 4 ? 28 : 32;
            int gridDimensions = gridSize == 4 ? 2 : 3;
            int firstRow = -1;
            int height = -1;
            int firstCol = -1;
            int width = -1;
            for (int row = 0; row < gridDimensions; ++row) {
                for (int col = 0; col < gridDimensions; ++col) {
                    if (inventory.getItem(col + row * gridDimensions + 1).isEmpty()) continue;
                    if (firstRow == -1) {
                        firstRow = row;
                        firstCol = col;
                    } else {
                        firstCol = Math.min(firstCol, col);
                    }
                    height = Math.max(height, row);
                    width = Math.max(width, col);
                }
            }
            if (firstRow == -1) {
                return;
            }
            if (InventoryUtils.getValidRecipe(session, item, inventory::getItem, gridDimensions, firstRow, height += -firstRow + 1, firstCol, width += -firstCol + 1) != null) {
                return;
            }
            UUID uuid = UUID.randomUUID();
            int newRecipeId = session.getLastRecipeNetId().incrementAndGet();
            ItemData[] ingredients = new ItemData[height * width];
            ArrayList<SlotDisplay> javaIngredients = new ArrayList<SlotDisplay>(height * width);
            int index = 0;
            for (int row = firstRow; row < height + firstRow; ++row) {
                for (int col = firstCol; col < width + firstCol; ++col) {
                    GeyserItemStack geyserItemStack = inventory.getItem(col + row * gridDimensions + 1);
                    ingredients[index] = geyserItemStack.getItemData(session);
                    javaIngredients.add(geyserItemStack.asSlotDisplay());
                    slotPacket = new InventorySlotPacket();
                    slotPacket.setContainerId(124);
                    slotPacket.setSlot(col + row * gridDimensions + offset);
                    slotPacket.setItem(ItemData.AIR);
                    session.sendUpstreamPacket((BedrockPacket)slotPacket);
                    ++index;
                }
            }
            session.getCraftingRecipes().put(newRecipeId, (Object)new GeyserShapedRecipe(width, height, javaIngredients, (SlotDisplay)new ItemStackSlotDisplay(item)));
            CraftingDataPacket craftPacket = new CraftingDataPacket();
            craftPacket.getCraftingData().add(ShapedRecipeData.shaped((String)uuid.toString(), (int)width, (int)height, Arrays.stream(ingredients).map(ItemDescriptorWithCount::fromItem).toList(), Collections.singletonList(ItemTranslator.translateToBedrock(session, item)), (UUID)uuid, (String)"crafting_table", (int)0, (int)newRecipeId, (boolean)false, (RecipeUnlockingRequirement)RecipeUnlockingRequirement.INVALID));
            craftPacket.setCleanRecipes(false);
            session.sendUpstreamPacket((BedrockPacket)craftPacket);
            index = 0;
            for (int row = firstRow; row < height + firstRow; ++row) {
                for (int col = firstCol; col < width + firstCol; ++col) {
                    slotPacket = new InventorySlotPacket();
                    slotPacket.setContainerId(124);
                    slotPacket.setSlot(col + row * gridDimensions + offset);
                    slotPacket.setItem(ingredients[index]);
                    session.sendUpstreamPacket((BedrockPacket)slotPacket);
                    ++index;
                }
            }
        }, 150L, TimeUnit.MILLISECONDS));
    }

    static void updateSmithingTableOutput(GeyserSession session, int slot, ItemStack output, Inventory inventory) {
        if (slot != 3) {
            return;
        }
        if (session.getContainerOutputFuture() != null) {
            session.getContainerOutputFuture().cancel(false);
        }
        if (InventoryUtils.isEmpty(output)) {
            return;
        }
        session.setContainerOutputFuture(session.scheduleInEventLoop(() -> {
            GeyserItemStack template = inventory.getItem(0);
            if (template.asItem() != Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE) {
                return;
            }
            GeyserItemStack input = inventory.getItem(1);
            GeyserItemStack material = inventory.getItem(2);
            GeyserItemStack geyserOutput = GeyserItemStack.from(output);
            for (GeyserSmithingRecipe recipe : session.getSmithingRecipes()) {
                if (!InventoryUtils.acceptsAsInput(session, recipe.result(), geyserOutput) || !InventoryUtils.acceptsAsInput(session, recipe.base(), input) || !InventoryUtils.acceptsAsInput(session, recipe.addition(), material) || !InventoryUtils.acceptsAsInput(session, recipe.template(), template)) continue;
                return;
            }
            session.getSmithingRecipes().add(new GeyserSmithingRecipe(template.asSlotDisplay(), input.asSlotDisplay(), material.asSlotDisplay(), (SlotDisplay)new ItemStackSlotDisplay(output)));
            UUID uuid = UUID.randomUUID();
            CraftingDataPacket craftPacket = new CraftingDataPacket();
            craftPacket.getCraftingData().add(SmithingTransformRecipeData.of((String)uuid.toString(), (ItemDescriptorWithCount)ItemDescriptorWithCount.fromItem((ItemData)ItemTranslator.translateToBedrock(session, template.getItemStack())), (ItemDescriptorWithCount)ItemDescriptorWithCount.fromItem((ItemData)ItemTranslator.translateToBedrock(session, input.getItemStack())), (ItemDescriptorWithCount)ItemDescriptorWithCount.fromItem((ItemData)ItemTranslator.translateToBedrock(session, material.getItemStack())), (ItemData)ItemTranslator.translateToBedrock(session, output), (String)"smithing_table", (int)session.getLastRecipeNetId().incrementAndGet()));
            craftPacket.setCleanRecipes(false);
            session.sendUpstreamPacket((BedrockPacket)craftPacket);
            InventorySlotPacket slotPacket = new InventorySlotPacket();
            slotPacket.setContainerId(124);
            slotPacket.setSlot(InventoryUtils.getInventoryTranslator(session).javaSlotToBedrock(2));
            slotPacket.setItem(ItemData.AIR);
            session.sendUpstreamPacket((BedrockPacket)slotPacket);
            InventoryUtils.getInventoryTranslator(session).updateSlot(session, inventory, 2);
        }, 150L, TimeUnit.MILLISECONDS));
    }
}

