/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.shaded.org.cloudburstmc.netty.handler.codec.raknet.common;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.geysermc.geyser.shaded.org.cloudburstmc.netty.channel.raknet.packet.EncapsulatedPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.netty.handler.codec.raknet.AdvancedChannelInboundHandler;
import org.geysermc.geyser.shaded.org.cloudburstmc.netty.handler.codec.raknet.common.RakSessionCodec;

public class ConnectedPongHandler
extends AdvancedChannelInboundHandler<EncapsulatedPacket> {
    public static final String NAME = "rak-connected-pong-handler";
    private final RakSessionCodec sessionCodec;

    public ConnectedPongHandler(RakSessionCodec sessionCodec) {
        this.sessionCodec = sessionCodec;
    }

    @Override
    protected boolean acceptInboundMessage(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!super.acceptInboundMessage(ctx, msg)) {
            return false;
        }
        ByteBuf buf = ((EncapsulatedPacket)((Object)msg)).getBuffer();
        return buf.getUnsignedByte(buf.readerIndex()) == 3;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, EncapsulatedPacket packet) throws Exception {
        ByteBuf buf = packet.getBuffer();
        buf.readUnsignedByte();
        long pingTime = buf.readLong();
        this.sessionCodec.recalculatePongTime(pingTime);
    }
}

