/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.velocity;

import com.velocitypowered.api.proxy.ProxyServer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.local.LocalAddress;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.network.netty.GeyserInjector;
import org.geysermc.geyser.network.netty.LocalServerChannelWrapper;
import org.geysermc.geyser.platform.velocity.GeyserVelocityCompressionDisabler;

public class GeyserVelocityInjector
extends GeyserInjector {
    private final ProxyServer proxy;

    public GeyserVelocityInjector(ProxyServer proxy) {
        this.proxy = proxy;
    }

    @Override
    protected void initializeLocalChannel0(final GeyserBootstrap bootstrap) throws Exception {
        ChannelFuture channelFuture;
        Field cm = this.proxy.getClass().getDeclaredField("cm");
        cm.setAccessible(true);
        Object connectionManager = cm.get(this.proxy);
        Class<?> connectionManagerClass = connectionManager.getClass();
        Supplier serverChannelInitializerHolder = (Supplier)connectionManagerClass.getMethod("getServerChannelInitializer", new Class[0]).invoke(connectionManager, new Object[0]);
        final ChannelInitializer channelInitializer = (ChannelInitializer)serverChannelInitializerHolder.get();
        Field serverWriteMarkField = connectionManagerClass.getDeclaredField("SERVER_WRITE_MARK");
        serverWriteMarkField.setAccessible(true);
        WriteBufferWaterMark serverWriteMark = (WriteBufferWaterMark)serverWriteMarkField.get(null);
        EventLoopGroup bossGroup = (EventLoopGroup)connectionManagerClass.getMethod("getBossGroup", new Class[0]).invoke(connectionManager, new Object[0]);
        Field workerGroupField = connectionManagerClass.getDeclaredField("workerGroup");
        workerGroupField.setAccessible(true);
        EventLoopGroup workerGroup = (EventLoopGroup)workerGroupField.get(connectionManager);
        final Method initChannel = ChannelInitializer.class.getDeclaredMethod("initChannel", Channel.class);
        initChannel.setAccessible(true);
        this.localChannel = channelFuture = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(LocalServerChannelWrapper.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(@NonNull Channel ch) throws Exception {
                initChannel.invoke((Object)channelInitializer, ch);
                if (bootstrap.getGeyserConfig().isDisableCompression() && GeyserVelocityCompressionDisabler.ENABLED) {
                    ch.pipeline().addAfter("minecraft-encoder", "geyser-compression-disabler", (ChannelHandler)new GeyserVelocityCompressionDisabler());
                }
            }
        }).group(bossGroup, workerGroup).childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)serverWriteMark).localAddress((SocketAddress)LocalAddress.ANY)).bind().syncUninterruptibly();
        this.serverSocketAddress = channelFuture.channel().localAddress();
    }
}

