/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.pack.path;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.pack.PathPackCodec;
import org.geysermc.geyser.api.pack.ResourcePack;
import org.geysermc.geyser.registry.loader.ResourcePackLoader;
import org.geysermc.geyser.util.FileUtils;

public class GeyserPathPackCodec
extends PathPackCodec {
    private final Path path;
    private FileTime lastModified;
    private byte[] sha256;
    private long size = -1L;

    @Override
    public @NonNull Path path() {
        this.checkLastModified();
        return this.path;
    }

    @Override
    public byte @NonNull [] sha256() {
        this.checkLastModified();
        if (this.sha256 != null) {
            return this.sha256;
        }
        this.sha256 = FileUtils.calculateSHA256(this.path);
        return this.sha256;
    }

    @Override
    public long size() {
        this.checkLastModified();
        if (this.size != -1L) {
            return this.size;
        }
        try {
            this.size = Files.size(this.path);
            return this.size;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get file size of path " + String.valueOf(this.path), e);
        }
    }

    @Override
    public @NonNull SeekableByteChannel serialize(@NonNull ResourcePack resourcePack) throws IOException {
        return FileChannel.open(this.path, new OpenOption[0]);
    }

    @Override
    protected @NonNull ResourcePack create() {
        return ResourcePackLoader.readPack(this.path);
    }

    private void checkLastModified() {
        try {
            FileTime lastModified = Files.getLastModifiedTime(this.path, new LinkOption[0]);
            if (this.lastModified == null) {
                this.lastModified = lastModified;
                return;
            }
            if (lastModified.toInstant().isAfter(this.lastModified.toInstant())) {
                GeyserImpl.getInstance().getLogger().warning("Detected a change in the resource pack " + String.valueOf(this.path) + ". This is likely to cause undefined behavior for new clients joining. It is suggested you restart Geyser.");
                this.lastModified = lastModified;
                this.sha256 = null;
                this.size = -1L;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public GeyserPathPackCodec(Path path) {
        this.path = path;
    }
}

