/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.erosion.packet.geyserbound;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.common.util.VarInts;
import org.geysermc.erosion.packet.ProtocolUtils;
import org.geysermc.erosion.packet.geyserbound.GeyserboundPacket;
import org.geysermc.erosion.packet.geyserbound.GeyserboundPacketHandler;

public final class GeyserboundPistonEventPacket
implements GeyserboundPacket {
    private static final byte IS_EXTEND_FLAG = 1;
    private static final byte IS_STICKY_FLAG = 2;
    private final int blockId;
    private final Vector3i pos;
    private final byte flags;
    private final Object2IntMap<Vector3i> attachedBlocks;

    public GeyserboundPistonEventPacket(int blockId, Vector3i pos, boolean isExtend, boolean isSticky, Object2IntMap<Vector3i> attachedBlocks) {
        this.blockId = blockId;
        this.pos = pos;
        byte flags = 0;
        if (isExtend) {
            flags = (byte)(flags | 1);
        }
        if (isSticky) {
            flags = (byte)(flags | 2);
        }
        this.flags = flags;
        this.attachedBlocks = attachedBlocks;
    }

    public GeyserboundPistonEventPacket(ByteBuf buf) {
        this.blockId = VarInts.readUnsignedInt(buf);
        this.pos = ProtocolUtils.readBlockPos(buf);
        this.flags = buf.readByte();
        int size = this.flags >> 2 & 0xF;
        this.attachedBlocks = new Object2IntArrayMap<Vector3i>(size);
        for (int i = 0; i < size; ++i) {
            byte relX = buf.readByte();
            byte relY = buf.readByte();
            byte relZ = buf.readByte();
            int networkId = VarInts.readUnsignedInt(buf);
            this.attachedBlocks.put(this.pos.add(relX, relY, relZ), networkId);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        VarInts.writeUnsignedInt(buf, this.blockId);
        ProtocolUtils.writeBlockPos(buf, this.pos);
        buf.writeByte(this.flags | this.attachedBlocks.size() << 2);
        Object2IntMaps.fastForEach(this.attachedBlocks, entry -> {
            Vector3i pos = (Vector3i)entry.getKey();
            buf.writeByte(pos.getX() - this.pos.getX());
            buf.writeByte(pos.getY() - this.pos.getY());
            buf.writeByte(pos.getZ() - this.pos.getZ());
            VarInts.writeUnsignedInt(buf, entry.getIntValue());
        });
    }

    @Override
    public void handle(GeyserboundPacketHandler packetHandler) {
        packetHandler.handlePistonEvent(this);
    }

    public int getBlockId() {
        return this.blockId;
    }

    public Vector3i getPos() {
        return this.pos;
    }

    public Object2IntMap<Vector3i> getAttachedBlocks() {
        return this.attachedBlocks;
    }

    public boolean isExtend() {
        return (this.flags & 1) != 0;
    }

    public boolean isSticky() {
        return (this.flags & 2) != 0;
    }

    public String toString() {
        return "GeyserboundPistonEventPacket{blockId=" + this.blockId + ", pos=" + String.valueOf(this.pos) + ", flags=" + this.flags + ", attachedBlocks=" + String.valueOf(this.attachedBlocks) + "}";
    }
}

