/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.Component;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;

public class ClientboundTabListPacket
implements MinecraftPacket {
    @lombok.NonNull
    private final Component header;
    @lombok.NonNull
    private final Component footer;

    public ClientboundTabListPacket(ByteBuf in) {
        this.header = MinecraftTypes.readComponent(in);
        this.footer = MinecraftTypes.readComponent(in);
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeComponent(out, this.header);
        MinecraftTypes.writeComponent(out, this.footer);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    @lombok.NonNull
    public Component getHeader() {
        return this.header;
    }

    @lombok.NonNull
    public Component getFooter() {
        return this.footer;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundTabListPacket)) {
            return false;
        }
        ClientboundTabListPacket other = (ClientboundTabListPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Component this$header = this.getHeader();
        Component other$header = other.getHeader();
        if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
            return false;
        }
        Component this$footer = this.getFooter();
        Component other$footer = other.getFooter();
        return !(this$footer == null ? other$footer != null : !this$footer.equals(other$footer));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundTabListPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Component $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : $header.hashCode());
        Component $footer = this.getFooter();
        result = result * 59 + ($footer == null ? 43 : $footer.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundTabListPacket(header=" + String.valueOf(this.getHeader()) + ", footer=" + String.valueOf(this.getFooter()) + ")";
    }

    public @NonNull ClientboundTabListPacket withHeader(@lombok.NonNull Component header) {
        if (header == null) {
            throw new NullPointerException("header is marked non-null but is null");
        }
        return this.header == header ? this : new ClientboundTabListPacket(header, this.footer);
    }

    public @NonNull ClientboundTabListPacket withFooter(@lombok.NonNull Component footer) {
        if (footer == null) {
            throw new NullPointerException("footer is marked non-null but is null");
        }
        return this.footer == footer ? this : new ClientboundTabListPacket(this.header, footer);
    }

    public ClientboundTabListPacket(@lombok.NonNull Component header, @lombok.NonNull Component footer) {
        if (header == null) {
            throw new NullPointerException("header is marked non-null but is null");
        }
        if (footer == null) {
            throw new NullPointerException("footer is marked non-null but is null");
        }
        this.header = header;
        this.footer = footer;
    }
}

