/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level.chunk;

import io.netty.buffer.ByteBuf;
import org.cloudburstmc.protocol.common.util.Preconditions;
import org.geysermc.geyser.level.chunk.BlockStorage;

public class GeyserChunkSection {
    private static final int CHUNK_SECTION_VERSION = 9;
    private final BlockStorage[] storage;
    private final int subChunkIndex;

    public GeyserChunkSection(int airBlockId, int subChunkIndex) {
        this(new BlockStorage[]{new BlockStorage(airBlockId), new BlockStorage(airBlockId)}, subChunkIndex);
    }

    public GeyserChunkSection(BlockStorage[] storage, int subChunkIndex) {
        this.storage = storage;
        this.subChunkIndex = subChunkIndex;
    }

    public int getFullBlock(int x, int y, int z, int layer) {
        GeyserChunkSection.checkBounds(x, y, z);
        Preconditions.checkElementIndex((int)layer, (int)this.storage.length);
        return this.storage[layer].getFullBlock(GeyserChunkSection.blockPosition(x, y, z));
    }

    public void setFullBlock(int x, int y, int z, int layer, int fullBlock) {
        GeyserChunkSection.checkBounds(x, y, z);
        Preconditions.checkElementIndex((int)layer, (int)this.storage.length);
        this.storage[layer].setFullBlock(GeyserChunkSection.blockPosition(x, y, z), fullBlock);
    }

    public void writeToNetwork(ByteBuf buffer) {
        buffer.writeByte(9);
        buffer.writeByte(this.storage.length);
        buffer.writeByte(this.subChunkIndex);
        for (BlockStorage blockStorage : this.storage) {
            blockStorage.writeToNetwork(buffer);
        }
    }

    public int estimateNetworkSize() {
        int size = 2;
        for (BlockStorage blockStorage : this.storage) {
            size += blockStorage.estimateNetworkSize();
        }
        return size;
    }

    public BlockStorage[] getBlockStorageArray() {
        return this.storage;
    }

    public boolean isEmpty() {
        for (BlockStorage blockStorage : this.storage) {
            if (blockStorage.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public GeyserChunkSection copy(int subChunkIndex) {
        BlockStorage[] storage = new BlockStorage[this.storage.length];
        for (int i = 0; i < storage.length; ++i) {
            storage[i] = this.storage[i].copy();
        }
        return new GeyserChunkSection(storage, subChunkIndex);
    }

    public static int blockPosition(int x, int y, int z) {
        return x << 8 | z << 4 | y;
    }

    private static void checkBounds(int x, int y, int z) {
        Preconditions.checkArgument((x >= 0 && x < 16 ? 1 : 0) != 0, (String)"x (%s) is not between 0 and 15", (int)x);
        Preconditions.checkArgument((y >= 0 && y < 16 ? 1 : 0) != 0, (String)"y (%s) is not between 0 and 15", (int)y);
        Preconditions.checkArgument((z >= 0 && z < 16 ? 1 : 0) != 0, (String)"z (%s) is not between 0 and 15", (int)z);
    }
}

