/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.registry.AbstractMappedRegistry;
import org.geysermc.geyser.registry.DeferredRegistry;
import org.geysermc.geyser.registry.loader.RegistryLoader;

public abstract class AbstractMappedDeferredRegistry<K, V, M extends Map<K, V>, R extends AbstractMappedRegistry<K, V, M>>
extends DeferredRegistry<M, R> {
    protected <I> AbstractMappedDeferredRegistry(Function<RegistryLoader<I, M>, R> registryLoader, RegistryLoader<I, M> deferredLoader) {
        super(registryLoader, deferredLoader);
    }

    protected <I> AbstractMappedDeferredRegistry(Function<RegistryLoader<I, M>, R> registryLoader, Supplier<RegistryLoader<I, M>> deferredLoader) {
        super(registryLoader, deferredLoader);
    }

    protected <I> AbstractMappedDeferredRegistry(I input, DeferredRegistry.RegistryInitializer<M, R> registryInitializer, RegistryLoader<I, M> deferredLoader) {
        super(input, registryInitializer, deferredLoader);
    }

    protected <I> AbstractMappedDeferredRegistry(I input, DeferredRegistry.RegistryInitializer<M, R> registryInitializer, Supplier<RegistryLoader<I, M>> deferredLoader) {
        super(input, registryInitializer, deferredLoader);
    }

    public @Nullable V get(K key) {
        return ((Map)this.get()).get(key);
    }

    public <U> Optional<U> map(K key, Function<? super V, ? extends U> mapper) {
        V value = this.get(key);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(value));
    }

    public V getOrDefault(K key, V defaultValue) {
        return ((Map)this.get()).getOrDefault(key, defaultValue);
    }

    public V register(K key, V value) {
        return ((Map)this.get()).put(key, value);
    }
}

