/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.shaded.org.spongepowered.configurate.serialize;

import java.lang.reflect.Type;
import java.util.UUID;
import java.util.function.Predicate;
import org.geysermc.geyser.shaded.org.spongepowered.configurate.serialize.CoercionFailedException;
import org.geysermc.geyser.shaded.org.spongepowered.configurate.serialize.ScalarSerializer;
import org.geysermc.geyser.shaded.org.spongepowered.configurate.serialize.SerializationException;

final class UuidSerializer
extends ScalarSerializer<UUID> {
    private static final char DASH = '-';

    UuidSerializer() {
        super(UUID.class);
    }

    @Override
    public UUID deserialize(Type type, Object obj) throws SerializationException {
        long[] arr;
        if (obj instanceof long[] && (arr = (long[])obj).length == 2) {
            return new UUID(arr[0], arr[1]);
        }
        String uuidStr = obj.toString();
        if (uuidStr.length() == 32) {
            uuidStr = new StringBuilder(36).append(uuidStr, 0, 8).append('-').append(uuidStr, 8, 12).append('-').append(uuidStr, 12, 16).append('-').append(uuidStr, 16, 20).append('-').append(uuidStr, 20, 32).toString();
        }
        try {
            return UUID.fromString(uuidStr);
        }
        catch (IllegalArgumentException ex) {
            throw new CoercionFailedException(obj, "UUID");
        }
    }

    @Override
    public Object serialize(UUID item, Predicate<Class<?>> typeSupported) {
        return item.toString();
    }
}

