/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.cloudburstmc.protocol.bedrock.packet.ModalFormRequestPacket;
import org.cloudburstmc.protocol.bedrock.packet.ModalFormResponsePacket;
import org.cloudburstmc.protocol.bedrock.packet.NetworkStackLatencyPacket;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.form.impl.FormDefinition;
import org.geysermc.cumulus.form.impl.FormDefinitions;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.geysermc.geyser.session.GeyserSession;

public class FormCache {
    private static final long MAGIC_FORM_IMAGE_HACK_TIMESTAMP = -1234567890L;
    private final FormDefinitions formDefinitions = FormDefinitions.instance();
    private final AtomicInteger formIdCounter = new AtomicInteger(0);
    private final Int2ObjectMap<Form> forms = new Int2ObjectOpenHashMap<Form>();
    private final GeyserSession session;

    public int addForm(Form form) {
        int formId = this.formIdCounter.getAndIncrement();
        this.forms.put(formId, form);
        return formId;
    }

    public void showForm(Form form) {
        int formId = this.addForm(form);
        if (this.session.getUpstream().isInitialized()) {
            this.sendForm(formId, form);
        }
    }

    private void sendForm(int formId, Form form) {
        String jsonData = this.formDefinitions.codecFor(form).jsonData((Form)form);
        ModalFormRequestPacket formRequestPacket = new ModalFormRequestPacket();
        formRequestPacket.setFormId(formId);
        formRequestPacket.setFormData(jsonData);
        this.session.sendUpstreamPacket(formRequestPacket);
        if (form instanceof SimpleForm) {
            NetworkStackLatencyPacket latencyPacket = new NetworkStackLatencyPacket();
            latencyPacket.setFromServer(true);
            latencyPacket.setTimestamp(-1234567890L);
            this.session.scheduleInEventLoop(() -> this.session.sendUpstreamPacket(latencyPacket), 500L, TimeUnit.MILLISECONDS);
        }
    }

    public void resendAllForms() {
        for (Int2ObjectMap.Entry entry : this.forms.int2ObjectEntrySet()) {
            this.sendForm(entry.getIntKey(), (Form)entry.getValue());
        }
    }

    public void handleResponse(ModalFormResponsePacket response) {
        Form form = (Form)this.forms.remove(response.getFormId());
        if (form == null) {
            return;
        }
        try {
            ((FormDefinition)this.formDefinitions.definitionFor(form)).handleFormResponse((Form)form, response.getFormData());
        }
        catch (Exception e) {
            GeyserImpl.getInstance().getLogger().error("Error while processing form response!", e);
        }
    }

    public FormCache(GeyserSession session) {
        this.session = session;
    }
}

