/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import org.cloudburstmc.protocol.bedrock.packet.CommandRequestPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.util.PlatformType;
import org.geysermc.geyser.command.CommandRegistry;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.translator.text.MessageTranslator;

@Translator(packet=CommandRequestPacket.class)
public class BedrockCommandRequestTranslator
extends PacketTranslator<CommandRequestPacket> {
    @Override
    public void translate(GeyserSession session, CommandRequestPacket packet) {
        String command = MessageTranslator.convertToPlainText(packet.getCommand());
        BedrockCommandRequestTranslator.handleCommand(session, MessageTranslator.normalizeSpace(command).substring(1));
    }

    static void handleCommand(GeyserSession session, String command) {
        String[] args;
        if ((session.getGeyser().getPlatformType() == PlatformType.STANDALONE || session.getGeyser().getPlatformType() == PlatformType.VIAPROXY) && (args = command.split(" ")).length > 0) {
            String root = args[0];
            CommandRegistry registry = GeyserImpl.getInstance().commandRegistry();
            if (registry.rootCommands().contains(root)) {
                registry.runCommand(session, command);
                return;
            }
        }
        if (MessageTranslator.isTooLong(command, session)) {
            return;
        }
        session.sendCommand(command);
    }
}

