/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.player;

import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.block.type.WallSkullBlock;
import org.geysermc.geyser.level.physics.Direction;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.SkullCache;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.GameType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.PlayerPermission;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.command.CommandPermission;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.AddPlayerPacket;
import org.geysermc.geyser.skin.SkullSkinManager;

public class SkullPlayerEntity
extends PlayerEntity {
    private UUID skullUUID;
    private Vector3i skullPosition;

    public SkullPlayerEntity(GeyserSession session, long geyserId) {
        super(session, 0, geyserId, UUID.randomUUID(), Vector3f.ZERO, Vector3f.ZERO, 0.0f, 0.0f, 0.0f, "", null);
    }

    @Override
    protected void initializeMetadata() {
        this.dirtyMetadata.put(EntityDataTypes.SCALE, Float.valueOf(1.08f));
        this.dirtyMetadata.put(EntityDataTypes.HEIGHT, Float.valueOf(0.001f));
        this.dirtyMetadata.put(EntityDataTypes.WIDTH, Float.valueOf(0.001f));
        this.setFlag(EntityFlag.CAN_SHOW_NAME, false);
        this.setFlag(EntityFlag.INVISIBLE, true);
    }

    @Override
    public void spawnEntity() {
        AddPlayerPacket addPlayerPacket = new AddPlayerPacket();
        addPlayerPacket.setUuid(this.getUuid());
        addPlayerPacket.setUsername(this.getUsername());
        addPlayerPacket.setRuntimeEntityId(this.geyserId);
        addPlayerPacket.setUniqueEntityId(this.geyserId);
        addPlayerPacket.setPosition(this.position.sub(0.0f, this.definition.offset(), 0.0f));
        addPlayerPacket.setRotation(this.getBedrockRotation());
        addPlayerPacket.setMotion(this.motion);
        addPlayerPacket.setHand(this.hand);
        addPlayerPacket.getAdventureSettings().setCommandPermission(CommandPermission.ANY);
        addPlayerPacket.getAdventureSettings().setPlayerPermission(PlayerPermission.MEMBER);
        addPlayerPacket.setDeviceId("");
        addPlayerPacket.setPlatformChatId("");
        addPlayerPacket.setGameType(GameType.SURVIVAL);
        addPlayerPacket.setAbilityLayers(BASE_ABILITY_LAYER);
        addPlayerPacket.getMetadata().putFlags(this.flags);
        this.dirtyMetadata.apply(addPlayerPacket.getMetadata());
        this.setFlagsDirty(false);
        this.valid = true;
        this.session.sendUpstreamPacket(addPlayerPacket);
    }

    public void updateSkull(SkullCache.Skull skull) {
        float rotation;
        this.skullPosition = skull.getPosition();
        if (!Objects.equals(skull.getTexturesProperty(), this.getTexturesProperty()) || !Objects.equals(this.skullUUID, skull.getUuid())) {
            this.setFlag(EntityFlag.INVISIBLE, true);
            this.updateBedrockMetadata();
            this.skullUUID = skull.getUuid();
            this.setTexturesProperty(skull.getTexturesProperty());
            SkullSkinManager.requestAndHandleSkin(this, this.session, skin -> this.session.scheduleInEventLoop(() -> {
                this.setFlag(EntityFlag.INVISIBLE, false);
                this.updateBedrockMetadata();
            }, 250L, TimeUnit.MILLISECONDS));
        } else {
            this.setFlag(EntityFlag.INVISIBLE, false);
            this.updateBedrockMetadata();
        }
        float x = (float)skull.getPosition().getX() + 0.5f;
        float y = (float)skull.getPosition().getY() - 0.01f;
        float z = (float)skull.getPosition().getZ() + 0.5f;
        BlockState blockState = skull.getBlockState();
        if (blockState.block() instanceof WallSkullBlock) {
            y += 0.25f;
            Direction direction = blockState.getValue(Properties.HORIZONTAL_FACING);
            rotation = WallSkullBlock.getDegrees(direction);
            switch (direction) {
                case NORTH: {
                    z += 0.24f;
                    break;
                }
                case SOUTH: {
                    z -= 0.24f;
                    break;
                }
                case WEST: {
                    x += 0.24f;
                    break;
                }
                case EAST: {
                    x -= 0.24f;
                }
            }
        } else {
            rotation = (180.0f + (float)blockState.getValue(Properties.ROTATION_16, 0).intValue() * 22.5f) % 360.0f;
        }
        this.moveAbsolute(Vector3f.from((float)x, (float)y, (float)z), rotation, 0.0f, rotation, true, true);
    }

    public UUID getSkullUUID() {
        return this.skullUUID;
    }

    public Vector3i getSkullPosition() {
        return this.skullPosition;
    }
}

