/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock.entity.player.input;

import java.util.BitSet;
import java.util.List;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.geyser.api.block.custom.CustomBlockState;
import org.geysermc.geyser.entity.type.ItemFrameEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.SkullCache;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.PlayerActionType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.PlayerBlockActionData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.LevelEventPacket;
import org.geysermc.geyser.translator.item.CustomItemTranslator;
import org.geysermc.geyser.util.BlockUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.InteractAction;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.PlayerAction;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundInteractPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundPlayerActionPacket;

final class BedrockBlockActions {
    BedrockBlockActions() {
    }

    static void translate(GeyserSession session, List<PlayerBlockActionData> playerActions) {
        session.getBookEditCache().checkForSend();
        for (PlayerBlockActionData blockActionData : playerActions) {
            BedrockBlockActions.handle(session, blockActionData);
        }
    }

    private static void handle(GeyserSession session, PlayerBlockActionData blockActionData) {
        PlayerActionType action = blockActionData.getAction();
        Vector3i vector = blockActionData.getBlockPosition();
        int blockFace = blockActionData.getFace();
        switch (action) {
            case DROP_ITEM: {
                ServerboundPlayerActionPacket dropItemPacket = new ServerboundPlayerActionPacket(PlayerAction.DROP_ITEM, vector, Direction.VALUES[blockFace], 0);
                session.sendDownstreamGamePacket(dropItemPacket);
                break;
            }
            case START_BREAK: {
                ServerboundPlayerActionPacket startBreakingPacket;
                if (session.getGameMode() == GameMode.CREATIVE) break;
                if (!BedrockBlockActions.canMine(session, vector)) {
                    return;
                }
                int blockState = session.getGeyser().getWorldManager().getBlockAt(session, vector);
                LevelEventPacket startBreak = new LevelEventPacket();
                startBreak.setType(LevelEvent.BLOCK_START_BREAK);
                startBreak.setPosition(vector.toFloat());
                double breakTime = BlockUtils.getSessionBreakTimeTicks(session, BlockState.of(blockState).block());
                GeyserItemStack item = session.getPlayerInventory().getItemInHand();
                ItemMapping mapping = item.getMapping(session);
                ItemDefinition customItem = mapping.isTool() ? CustomItemTranslator.getCustomItem(item.getComponents(), mapping) : null;
                CustomBlockState blockStateOverride = (CustomBlockState)BlockRegistries.CUSTOM_BLOCK_STATE_OVERRIDES.get(blockState);
                SkullCache.Skull skull = session.getSkullCache().getSkulls().get(vector);
                session.setBlockBreakStartTime(0L);
                if (((BitSet)BlockRegistries.NON_VANILLA_BLOCK_IDS.get()).get(blockState) || blockStateOverride != null || customItem != null || skull != null && skull.getBlockDefinition() != null) {
                    session.setBlockBreakStartTime(System.currentTimeMillis());
                }
                startBreak.setData((int)(65535.0 / breakTime));
                session.setBreakingBlock(blockState);
                session.sendUpstreamPacket(startBreak);
                Vector3i fireBlockPos = BlockUtils.getBlockPosition(vector, blockFace);
                Block block = session.getGeyser().getWorldManager().blockAt(session, fireBlockPos).block();
                Direction direction = Direction.VALUES[blockFace];
                if (block == Blocks.FIRE || block == Blocks.SOUL_FIRE) {
                    startBreakingPacket = new ServerboundPlayerActionPacket(PlayerAction.START_DIGGING, fireBlockPos, direction, session.getWorldCache().nextPredictionSequence());
                    session.sendDownstreamGamePacket(startBreakingPacket);
                }
                startBreakingPacket = new ServerboundPlayerActionPacket(PlayerAction.START_DIGGING, vector, direction, session.getWorldCache().nextPredictionSequence());
                session.sendDownstreamGamePacket(startBreakingPacket);
                BedrockBlockActions.spawnBlockBreakParticles(session, direction, vector, BlockState.of(blockState));
                break;
            }
            case CONTINUE_BREAK: {
                if (session.getGameMode() == GameMode.CREATIVE) break;
                if (!BedrockBlockActions.canMine(session, vector)) {
                    return;
                }
                int breakingBlock = session.getBreakingBlock();
                if (breakingBlock == -1) {
                    breakingBlock = 0;
                }
                Vector3f vectorFloat = vector.toFloat();
                BlockState breakingBlockState = BlockState.of(breakingBlock);
                Direction direction = Direction.VALUES[blockFace];
                BedrockBlockActions.spawnBlockBreakParticles(session, direction, vector, breakingBlockState);
                double breakTime = BlockUtils.getSessionBreakTimeTicks(session, breakingBlockState.block());
                long blockBreakStartTime = session.getBlockBreakStartTime();
                if (blockBreakStartTime != 0L) {
                    double d;
                    long timeSinceStart = System.currentTimeMillis() - blockBreakStartTime;
                    breakTime += 2.0;
                    if ((double)timeSinceStart >= d * 50.0) {
                        LevelEventPacket effectPacket = new LevelEventPacket();
                        effectPacket.setPosition(vectorFloat);
                        effectPacket.setType(LevelEvent.PARTICLE_DESTROY_BLOCK);
                        effectPacket.setData(session.getBlockMappings().getBedrockBlockId(breakingBlock));
                        session.sendUpstreamPacket(effectPacket);
                        ServerboundPlayerActionPacket finishBreakingPacket = new ServerboundPlayerActionPacket(PlayerAction.FINISH_DIGGING, vector, direction, session.getWorldCache().nextPredictionSequence());
                        session.sendDownstreamGamePacket(finishBreakingPacket);
                        session.setBlockBreakStartTime(0L);
                        break;
                    }
                }
                LevelEventPacket updateBreak = new LevelEventPacket();
                updateBreak.setType(LevelEvent.BLOCK_UPDATE_BREAK);
                updateBreak.setPosition(vectorFloat);
                updateBreak.setData((int)(65535.0 / breakTime));
                session.sendUpstreamPacket(updateBreak);
                break;
            }
            case ABORT_BREAK: {
                ItemFrameEntity itemFrameEntity;
                if (session.getGameMode() != GameMode.CREATIVE && (itemFrameEntity = ItemFrameEntity.getItemFrameEntity(session, vector)) != null) {
                    ServerboundInteractPacket interactPacket = new ServerboundInteractPacket(itemFrameEntity.getEntityId(), InteractAction.ATTACK, Hand.MAIN_HAND, session.isSneaking());
                    session.sendDownstreamGamePacket(interactPacket);
                    break;
                }
                ServerboundPlayerActionPacket abortBreakingPacket = new ServerboundPlayerActionPacket(PlayerAction.CANCEL_DIGGING, vector, Direction.DOWN, 0);
                session.sendDownstreamGamePacket(abortBreakingPacket);
                LevelEventPacket stopBreak = new LevelEventPacket();
                stopBreak.setType(LevelEvent.BLOCK_STOP_BREAK);
                stopBreak.setPosition(vector.toFloat());
                stopBreak.setData(0);
                session.setBreakingBlock(-1);
                session.setBlockBreakStartTime(0L);
                session.sendUpstreamPacket(stopBreak);
                break;
            }
        }
    }

    private static boolean canMine(GeyserSession session, Vector3i vector) {
        if (session.isHandsBusy()) {
            session.setBreakingBlock(-1);
            session.setBlockBreakStartTime(0L);
            LevelEventPacket stopBreak = new LevelEventPacket();
            stopBreak.setType(LevelEvent.BLOCK_STOP_BREAK);
            stopBreak.setPosition(vector.toFloat());
            stopBreak.setData(0);
            session.setBreakingBlock(-1);
            session.sendUpstreamPacket(stopBreak);
            return false;
        }
        return true;
    }

    private static void spawnBlockBreakParticles(GeyserSession session, Direction direction, Vector3i position, BlockState blockState) {
        LevelEventPacket levelEventPacket = new LevelEventPacket();
        switch (direction) {
            case UP: {
                levelEventPacket.setType(LevelEvent.PARTICLE_BREAK_BLOCK_UP);
                break;
            }
            case DOWN: {
                levelEventPacket.setType(LevelEvent.PARTICLE_BREAK_BLOCK_DOWN);
                break;
            }
            case NORTH: {
                levelEventPacket.setType(LevelEvent.PARTICLE_BREAK_BLOCK_NORTH);
                break;
            }
            case EAST: {
                levelEventPacket.setType(LevelEvent.PARTICLE_BREAK_BLOCK_EAST);
                break;
            }
            case SOUTH: {
                levelEventPacket.setType(LevelEvent.PARTICLE_BREAK_BLOCK_SOUTH);
                break;
            }
            case WEST: {
                levelEventPacket.setType(LevelEvent.PARTICLE_BREAK_BLOCK_WEST);
            }
        }
        levelEventPacket.setPosition(position.toFloat());
        levelEventPacket.setData(session.getBlockMappings().getBedrockBlock(blockState).getRuntimeId());
        session.sendUpstreamPacket(levelEventPacket);
    }
}

