/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequest;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequestSlotData;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.CraftRecipeOptionalAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestActionType;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponse;
import org.geysermc.geyser.inventory.AnvilContainer;
import org.geysermc.geyser.inventory.BedrockContainerSlot;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.PlayerInventory;
import org.geysermc.geyser.inventory.updater.AnvilInventoryUpdater;
import org.geysermc.geyser.inventory.updater.InventoryUpdater;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.AbstractBlockInventoryTranslator;

public class AnvilInventoryTranslator
extends AbstractBlockInventoryTranslator {
    public AnvilInventoryTranslator() {
        super(3, Blocks.ANVIL, ContainerType.ANVIL, (InventoryUpdater)AnvilInventoryUpdater.INSTANCE, Blocks.CHIPPED_ANVIL, Blocks.DAMAGED_ANVIL);
    }

    @Override
    protected boolean shouldHandleRequestFirst(ItemStackRequestAction action, Inventory inventory) {
        return action.getType() == ItemStackRequestActionType.CRAFT_RECIPE_OPTIONAL;
    }

    @Override
    protected ItemStackResponse translateSpecialRequest(GeyserSession session, Inventory inventory, ItemStackRequest request) {
        String name;
        CraftRecipeOptionalAction data = (CraftRecipeOptionalAction)request.getActions()[0];
        AnvilContainer container = (AnvilContainer)inventory;
        if (request.getFilterStrings().length != 0 && !Objects.equals(name = request.getFilterStrings()[data.getFilteredStringIndex()], container.getNewName())) {
            container.checkForRename(session, name);
        }
        return super.translateRequest(session, inventory, request);
    }

    @Override
    public int bedrockSlotToJava(ItemStackRequestSlotData slotInfoData) {
        return switch (slotInfoData.getContainerName().getContainer()) {
            case ContainerSlotType.ANVIL_INPUT -> 0;
            case ContainerSlotType.ANVIL_MATERIAL -> 1;
            case ContainerSlotType.ANVIL_RESULT, ContainerSlotType.CREATED_OUTPUT -> 2;
            default -> super.bedrockSlotToJava(slotInfoData);
        };
    }

    @Override
    public BedrockContainerSlot javaSlotToBedrockContainer(int slot) {
        return switch (slot) {
            case 0 -> new BedrockContainerSlot(ContainerSlotType.ANVIL_INPUT, 1);
            case 1 -> new BedrockContainerSlot(ContainerSlotType.ANVIL_MATERIAL, 2);
            case 2 -> new BedrockContainerSlot(ContainerSlotType.ANVIL_RESULT, 50);
            default -> super.javaSlotToBedrockContainer(slot);
        };
    }

    @Override
    public int javaSlotToBedrock(int slot) {
        return switch (slot) {
            case 0 -> 1;
            case 1 -> 2;
            case 2 -> 50;
            default -> super.javaSlotToBedrock(slot);
        };
    }

    @Override
    public Inventory createInventory(GeyserSession session, String name, int windowId, org.geysermc.mcprotocollib.protocol.data.game.inventory.ContainerType containerType, PlayerInventory playerInventory) {
        return new AnvilContainer(session, name, windowId, this.size, containerType, playerInventory, this);
    }

    @Override
    public void updateProperty(GeyserSession session, Inventory inventory, int key, int value) {
        if (key != 0) {
            return;
        }
        AnvilContainer anvilContainer = (AnvilContainer)inventory;
        anvilContainer.setJavaLevelCost(value);
        anvilContainer.setUseJavaLevelCost(true);
        this.updateSlot(session, anvilContainer, 1);
    }

    @Override
    public @Nullable ContainerType closeContainerType(Inventory inventory) {
        return null;
    }
}

