/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal;

import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.session.cache.tags.Tag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;

public class HoglinEntity
extends AnimalEntity {
    private boolean isImmuneToZombification;

    public HoglinEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
        this.dirtyMetadata.put(EntityDataTypes.TARGET_EID, session.getPlayerEntity().getGeyserId());
        this.setFlag(EntityFlag.SHAKING, this.isShaking());
    }

    public void setImmuneToZombification(BooleanEntityMetadata entityMetadata) {
        this.isImmuneToZombification = entityMetadata.getPrimitiveValue();
        this.setFlag(EntityFlag.SHAKING, this.isShaking());
    }

    @Override
    protected boolean isShaking() {
        return !this.isImmuneToZombification && !this.session.getDimensionType().piglinSafe() || super.isShaking();
    }

    @Override
    protected @Nullable Tag<Item> getFoodTag() {
        return ItemTag.HOGLIN_FOOD;
    }

    @Override
    public boolean canBeLeashed() {
        return this.isNotLeashed();
    }

    @Override
    protected boolean isEnemy() {
        return true;
    }

    @Override
    public boolean useArmSwingAttack() {
        return true;
    }
}

