/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.inventory;

import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.InventoryHolder;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.SmithingInventoryTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.translator.protocol.java.inventory.JavaContainerSetSlotTranslator;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.inventory.ClientboundContainerSetContentPacket;

@Translator(packet=ClientboundContainerSetContentPacket.class)
public class JavaContainerSetContentTranslator
extends PacketTranslator<ClientboundContainerSetContentPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundContainerSetContentPacket packet) {
        InventoryHolder<?> holder = InventoryUtils.getInventory(session, packet.getContainerId());
        if (holder == null) {
            return;
        }
        Object inventory = holder.inventory();
        int inventorySize = ((Inventory)inventory).getSize();
        for (int i = 0; i < packet.getItems().length; ++i) {
            if (i >= inventorySize) {
                GeyserLogger logger = session.getGeyser().getLogger();
                logger.warning("ClientboundContainerSetContentPacket sent to " + session.bedrockUsername() + " that exceeds inventory size!");
                if (logger.isDebug()) {
                    logger.debug(packet);
                    logger.debug(inventory);
                }
                holder.updateInventory();
                return;
            }
            GeyserItemStack newItem = GeyserItemStack.from(packet.getItems()[i]);
            session.getBundleCache().initialize(newItem);
            ((Inventory)inventory).setItem(i, newItem, session);
        }
        holder.updateInventory();
        int stateId = packet.getStateId();
        session.setEmulatePost1_16Logic(stateId > 0 || stateId != ((Inventory)inventory).getStateId());
        ((Inventory)inventory).setStateId(stateId);
        GeyserItemStack cursor = GeyserItemStack.from(packet.getCarriedItem());
        session.getBundleCache().initialize(cursor);
        session.getPlayerInventory().setCursor(cursor, session);
        InventoryUtils.updateCursor(session);
        if (holder.translator() instanceof SmithingInventoryTranslator) {
            JavaContainerSetSlotTranslator.updateSmithingTableOutput(3, packet.getItems()[3], holder);
        }
    }
}

