/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.spigot;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Iterator;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.util.CachedServerIcon;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.ping.GeyserPingInfo;
import org.geysermc.geyser.ping.IGeyserPingPassthrough;
import org.geysermc.geyser.platform.spigot.GeyserSpigotLogger;

public class GeyserSpigotPingPassthrough
implements IGeyserPingPassthrough {
    private final GeyserSpigotLogger logger;

    @Override
    public @Nullable GeyserPingInfo getPingInformation(InetSocketAddress inetSocketAddress) {
        try {
            GeyserPingEvent event = new GeyserPingEvent(inetSocketAddress.getAddress(), Bukkit.getMotd(), Bukkit.getOnlinePlayers().size(), Bukkit.getMaxPlayers());
            Bukkit.getPluginManager().callEvent((Event)event);
            return new GeyserPingInfo(event.getMotd(), event.getMaxPlayers(), event.getNumPlayers());
        }
        catch (Exception | LinkageError e) {
            this.logger.debug("Error while getting Bukkit ping passthrough: " + String.valueOf(e));
            return null;
        }
    }

    public GeyserSpigotPingPassthrough(GeyserSpigotLogger logger) {
        this.logger = logger;
    }

    private static class GeyserPingEvent
    extends ServerListPingEvent {
        public GeyserPingEvent(InetAddress address, String motd, int numPlayers, int maxPlayers) {
            super("", address, motd, numPlayers, maxPlayers);
        }

        public void setServerIcon(CachedServerIcon icon) throws IllegalArgumentException, UnsupportedOperationException {
        }

        public @NonNull Iterator<Player> iterator() throws UnsupportedOperationException {
            return Collections.emptyIterator();
        }
    }
}

