/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.network;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodec;
import org.cloudburstmc.protocol.bedrock.codec.v786.Bedrock_v786;
import org.cloudburstmc.protocol.bedrock.codec.v800.Bedrock_v800;
import org.cloudburstmc.protocol.bedrock.codec.v818.Bedrock_v818;
import org.cloudburstmc.protocol.bedrock.codec.v819.Bedrock_v819;
import org.geysermc.geyser.api.util.MinecraftVersion;
import org.geysermc.geyser.impl.MinecraftVersionImpl;
import org.geysermc.geyser.network.CodecProcessor;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodec;
import org.geysermc.mcprotocollib.protocol.codec.PacketCodec;

public final class GameProtocol {
    private static final List<BedrockCodec> SUPPORTED_BEDROCK_CODECS = new ArrayList<BedrockCodec>();
    public static final IntList SUPPORTED_BEDROCK_PROTOCOLS = new IntArrayList();
    public static final List<MinecraftVersion> SUPPORTED_BEDROCK_VERSIONS = new ArrayList<MinecraftVersion>();
    public static final int DEFAULT_BEDROCK_PROTOCOL;
    public static final String DEFAULT_BEDROCK_VERSION;
    private static final PacketCodec DEFAULT_JAVA_CODEC;

    private static void register(BedrockCodec codec, String ... minecraftVersions) {
        codec = CodecProcessor.processCodec(codec);
        SUPPORTED_BEDROCK_CODECS.add(codec);
        SUPPORTED_BEDROCK_PROTOCOLS.add(codec.getProtocolVersion());
        for (String version : minecraftVersions) {
            SUPPORTED_BEDROCK_VERSIONS.add(new MinecraftVersionImpl(version, codec.getProtocolVersion()));
        }
    }

    private static void register(BedrockCodec codec) {
        GameProtocol.register(codec, codec.getMinecraftVersion());
    }

    public static @Nullable BedrockCodec getBedrockCodec(int protocolVersion) {
        for (BedrockCodec packetCodec : SUPPORTED_BEDROCK_CODECS) {
            if (packetCodec.getProtocolVersion() != protocolVersion) continue;
            return packetCodec;
        }
        return null;
    }

    public static boolean isTheOneVersionWithBrokenForms(GeyserSession session) {
        return session.protocolVersion() == Bedrock_v786.CODEC.getProtocolVersion();
    }

    public static boolean is1_21_80orHigher(GeyserSession session) {
        return session.protocolVersion() >= Bedrock_v800.CODEC.getProtocolVersion();
    }

    public static boolean is1_21_90orHigher(GeyserSession session) {
        return session.protocolVersion() >= Bedrock_v818.CODEC.getProtocolVersion();
    }

    public static boolean is1_21_80(GeyserSession session) {
        return session.protocolVersion() == Bedrock_v800.CODEC.getProtocolVersion();
    }

    public static List<String> getJavaVersions() {
        return List.of(DEFAULT_JAVA_CODEC.getMinecraftVersion(), "1.21.8");
    }

    public static int getJavaProtocolVersion() {
        return DEFAULT_JAVA_CODEC.getProtocolVersion();
    }

    public static String getJavaMinecraftVersion() {
        return "1.21.8";
    }

    public static String getAllSupportedBedrockVersions() {
        return SUPPORTED_BEDROCK_VERSIONS.stream().map(MinecraftVersion::versionString).collect(Collectors.joining(", "));
    }

    public static String getAllSupportedJavaVersions() {
        return String.join((CharSequence)", ", GameProtocol.getJavaVersions());
    }

    private GameProtocol() {
    }

    static {
        DEFAULT_JAVA_CODEC = MinecraftCodec.CODEC;
        GameProtocol.register(Bedrock_v786.CODEC, "1.21.70", "1.21.71", "1.21.72", "1.21.73");
        GameProtocol.register(Bedrock_v800.CODEC, "1.21.80", "1.21.81", "1.21.82", "1.21.83", "1.21.84");
        GameProtocol.register(Bedrock_v818.CODEC, "1.21.90", "1.21.91", "1.21.92");
        GameProtocol.register(Bedrock_v819.CODEC, "1.21.93", "1.21.94");
        MinecraftVersion latestBedrock = SUPPORTED_BEDROCK_VERSIONS.get(SUPPORTED_BEDROCK_VERSIONS.size() - 1);
        DEFAULT_BEDROCK_VERSION = latestBedrock.versionString();
        DEFAULT_BEDROCK_PROTOCOL = latestBedrock.protocolVersion();
    }
}

