/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.inventory;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.VillagerTrade;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;

public class ClientboundMerchantOffersPacket
implements MinecraftPacket {
    private final int containerId;
    @lombok.NonNull
    private final List<VillagerTrade> offers;
    private final int villagerLevel;
    private final int villagerXp;
    private final boolean showProgress;
    private final boolean canRestock;

    public ClientboundMerchantOffersPacket(ByteBuf in) {
        this.containerId = MinecraftTypes.readVarInt(in);
        this.offers = MinecraftTypes.readList(in, input -> {
            VillagerTrade.ItemCost baseCostA = MinecraftTypes.readItemCost(in);
            ItemStack result = MinecraftTypes.readItemStack(in);
            VillagerTrade.ItemCost costB = MinecraftTypes.readNullable(in, MinecraftTypes::readItemCost);
            boolean outOfStock = in.readBoolean();
            int uses = in.readInt();
            int maxUses = in.readInt();
            int xp = in.readInt();
            int specialPriceDiff = in.readInt();
            float priceMultiplier = in.readFloat();
            int demand = in.readInt();
            return new VillagerTrade(baseCostA, result, costB, outOfStock, uses, maxUses, xp, specialPriceDiff, priceMultiplier, demand);
        });
        this.villagerLevel = MinecraftTypes.readVarInt(in);
        this.villagerXp = MinecraftTypes.readVarInt(in);
        this.showProgress = in.readBoolean();
        this.canRestock = in.readBoolean();
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.containerId);
        MinecraftTypes.writeList(out, this.offers, (output, offer) -> {
            MinecraftTypes.writeItemCost(out, offer.getItemCostA());
            MinecraftTypes.writeItemStack(out, offer.getResult());
            MinecraftTypes.writeNullable(out, offer.getItemCostB(), MinecraftTypes::writeItemCost);
            out.writeBoolean(offer.isOutOfStock());
            out.writeInt(offer.getUses());
            out.writeInt(offer.getMaxUses());
            out.writeInt(offer.getXp());
            out.writeInt(offer.getSpecialPriceDiff());
            out.writeFloat(offer.getPriceMultiplier());
            out.writeInt(offer.getDemand());
        });
        MinecraftTypes.writeVarInt(out, this.villagerLevel);
        MinecraftTypes.writeVarInt(out, this.villagerXp);
        out.writeBoolean(this.showProgress);
        out.writeBoolean(this.canRestock);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getContainerId() {
        return this.containerId;
    }

    @lombok.NonNull
    public List<VillagerTrade> getOffers() {
        return this.offers;
    }

    public int getVillagerLevel() {
        return this.villagerLevel;
    }

    public int getVillagerXp() {
        return this.villagerXp;
    }

    public boolean isShowProgress() {
        return this.showProgress;
    }

    public boolean isCanRestock() {
        return this.canRestock;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundMerchantOffersPacket)) {
            return false;
        }
        ClientboundMerchantOffersPacket other = (ClientboundMerchantOffersPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContainerId() != other.getContainerId()) {
            return false;
        }
        if (this.getVillagerLevel() != other.getVillagerLevel()) {
            return false;
        }
        if (this.getVillagerXp() != other.getVillagerXp()) {
            return false;
        }
        if (this.isShowProgress() != other.isShowProgress()) {
            return false;
        }
        if (this.isCanRestock() != other.isCanRestock()) {
            return false;
        }
        List<VillagerTrade> this$offers = this.getOffers();
        List<VillagerTrade> other$offers = other.getOffers();
        return !(this$offers == null ? other$offers != null : !((Object)this$offers).equals(other$offers));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundMerchantOffersPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContainerId();
        result = result * 59 + this.getVillagerLevel();
        result = result * 59 + this.getVillagerXp();
        result = result * 59 + (this.isShowProgress() ? 79 : 97);
        result = result * 59 + (this.isCanRestock() ? 79 : 97);
        List<VillagerTrade> $offers = this.getOffers();
        result = result * 59 + ($offers == null ? 43 : ((Object)$offers).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundMerchantOffersPacket(containerId=" + this.getContainerId() + ", offers=" + String.valueOf(this.getOffers()) + ", villagerLevel=" + this.getVillagerLevel() + ", villagerXp=" + this.getVillagerXp() + ", showProgress=" + this.isShowProgress() + ", canRestock=" + this.isCanRestock() + ")";
    }

    public @NonNull ClientboundMerchantOffersPacket withContainerId(int containerId) {
        return this.containerId == containerId ? this : new ClientboundMerchantOffersPacket(containerId, this.offers, this.villagerLevel, this.villagerXp, this.showProgress, this.canRestock);
    }

    public @NonNull ClientboundMerchantOffersPacket withOffers(@lombok.NonNull List<VillagerTrade> offers) {
        if (offers == null) {
            throw new NullPointerException("offers is marked non-null but is null");
        }
        return this.offers == offers ? this : new ClientboundMerchantOffersPacket(this.containerId, offers, this.villagerLevel, this.villagerXp, this.showProgress, this.canRestock);
    }

    public @NonNull ClientboundMerchantOffersPacket withVillagerLevel(int villagerLevel) {
        return this.villagerLevel == villagerLevel ? this : new ClientboundMerchantOffersPacket(this.containerId, this.offers, villagerLevel, this.villagerXp, this.showProgress, this.canRestock);
    }

    public @NonNull ClientboundMerchantOffersPacket withVillagerXp(int villagerXp) {
        return this.villagerXp == villagerXp ? this : new ClientboundMerchantOffersPacket(this.containerId, this.offers, this.villagerLevel, villagerXp, this.showProgress, this.canRestock);
    }

    public @NonNull ClientboundMerchantOffersPacket withShowProgress(boolean showProgress) {
        return this.showProgress == showProgress ? this : new ClientboundMerchantOffersPacket(this.containerId, this.offers, this.villagerLevel, this.villagerXp, showProgress, this.canRestock);
    }

    public @NonNull ClientboundMerchantOffersPacket withCanRestock(boolean canRestock) {
        return this.canRestock == canRestock ? this : new ClientboundMerchantOffersPacket(this.containerId, this.offers, this.villagerLevel, this.villagerXp, this.showProgress, canRestock);
    }

    public ClientboundMerchantOffersPacket(int containerId, @lombok.NonNull List<VillagerTrade> offers, int villagerLevel, int villagerXp, boolean showProgress, boolean canRestock) {
        if (offers == null) {
            throw new NullPointerException("offers is marked non-null but is null");
        }
        this.containerId = containerId;
        this.offers = offers;
        this.villagerLevel = villagerLevel;
        this.villagerXp = villagerXp;
        this.showProgress = showProgress;
        this.canRestock = canRestock;
    }
}

