/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory.updater;

import java.util.Arrays;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.packet.InventoryContentPacket;
import org.cloudburstmc.protocol.bedrock.packet.InventorySlotPacket;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;

public class InventoryUpdater {
    public void updateInventory(InventoryTranslator<?> translator, GeyserSession session, Inventory inventory) {
        ItemData[] bedrockItems = new ItemData[36];
        for (int i = 0; i < 36; ++i) {
            int offset = i < 9 ? 27 : -9;
            bedrockItems[i] = inventory.getItem(translator.size + i + offset).getItemData(session);
        }
        InventoryContentPacket contentPacket = new InventoryContentPacket();
        contentPacket.setContainerId(0);
        contentPacket.setContents(Arrays.asList(bedrockItems));
        session.sendUpstreamPacket(contentPacket);
    }

    public boolean updateSlot(InventoryTranslator<?> translator, GeyserSession session, Inventory inventory, int javaSlot) {
        if (javaSlot >= translator.size) {
            InventorySlotPacket slotPacket = new InventorySlotPacket();
            slotPacket.setContainerId(0);
            slotPacket.setSlot(translator.javaSlotToBedrock(javaSlot));
            slotPacket.setItem(inventory.getItem(javaSlot).getItemData(session));
            session.sendUpstreamPacket(slotPacket);
            return true;
        }
        return false;
    }
}

