/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.step.msa;

import java.net.ServerSocket;
import java.net.URL;
import java.util.function.Consumer;
import lombok.Generated;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.utils.URLWrapper;
import net.raphimc.minecraftauth.step.AbstractStep;
import net.raphimc.minecraftauth.step.msa.InitialPreparationStep;
import net.raphimc.minecraftauth.util.logging.ILogger;

public class StepLocalWebServer
extends InitialPreparationStep<LocalWebServerCallback, LocalWebServer> {
    public StepLocalWebServer(AbstractStep.ApplicationDetails applicationDetails) {
        super("localWebServer", applicationDetails);
        if (applicationDetails.getRedirectUri().endsWith("/")) {
            throw new IllegalArgumentException("Redirect URI must not end with a slash");
        }
    }

    @Override
    protected LocalWebServer execute(ILogger logger, HttpClient httpClient, LocalWebServerCallback localWebServerCallback) throws Exception {
        logger.info(this, "Creating URL for MSA login via local webserver...");
        if (localWebServerCallback == null) {
            throw new IllegalStateException("Missing StepLocalWebServer.LocalWebServerCallback input");
        }
        try (ServerSocket localServer = new ServerSocket(0);){
            int localPort = localServer.getLocalPort();
            URL authenticationUrl = new URLWrapper(this.applicationDetails.getOAuthEnvironment().getAuthorizeUrl()).wrapQuery().addQueries(this.applicationDetails.getOAuthParameters()).setQuery("redirect_uri", this.applicationDetails.getRedirectUri() + ":" + localPort).setQuery("prompt", "select_account").apply().toURL();
            LocalWebServer localWebServer = new LocalWebServer(authenticationUrl.toString(), localPort);
            logger.info(this, "Created local webserver MSA authentication URL: " + localWebServer.getAuthenticationUrl());
            localWebServerCallback.callback.accept(localWebServer);
            LocalWebServer localWebServer2 = localWebServer;
            return localWebServer2;
        }
    }

    public static final class LocalWebServerCallback
    extends AbstractStep.InitialInput {
        private final Consumer<LocalWebServer> callback;

        @Generated
        public LocalWebServerCallback(Consumer<LocalWebServer> callback) {
            this.callback = callback;
        }

        @Generated
        public Consumer<LocalWebServer> getCallback() {
            return this.callback;
        }

        @Generated
        public String toString() {
            return "StepLocalWebServer.LocalWebServerCallback(callback=" + this.getCallback() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LocalWebServerCallback)) {
                return false;
            }
            LocalWebServerCallback other = (LocalWebServerCallback)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Consumer<LocalWebServer> this$callback = this.getCallback();
            Consumer<LocalWebServer> other$callback = other.getCallback();
            return !(this$callback == null ? other$callback != null : !this$callback.equals(other$callback));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LocalWebServerCallback;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Consumer<LocalWebServer> $callback = this.getCallback();
            result = result * 59 + ($callback == null ? 43 : $callback.hashCode());
            return result;
        }
    }

    public static final class LocalWebServer
    extends AbstractStep.InitialInput {
        private final String authenticationUrl;
        private final int port;

        @Generated
        public LocalWebServer(String authenticationUrl, int port) {
            this.authenticationUrl = authenticationUrl;
            this.port = port;
        }

        @Generated
        public String getAuthenticationUrl() {
            return this.authenticationUrl;
        }

        @Generated
        public int getPort() {
            return this.port;
        }

        @Generated
        public String toString() {
            return "StepLocalWebServer.LocalWebServer(authenticationUrl=" + this.getAuthenticationUrl() + ", port=" + this.getPort() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LocalWebServer)) {
                return false;
            }
            LocalWebServer other = (LocalWebServer)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            String this$authenticationUrl = this.getAuthenticationUrl();
            String other$authenticationUrl = other.getAuthenticationUrl();
            return !(this$authenticationUrl == null ? other$authenticationUrl != null : !this$authenticationUrl.equals(other$authenticationUrl));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LocalWebServer;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPort();
            String $authenticationUrl = this.getAuthenticationUrl();
            result = result * 59 + ($authenticationUrl == null ? 43 : $authenticationUrl.hashCode());
            return result;
        }
    }
}

