/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.pack;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.api.pack.ResourcePackManifest;
import org.geysermc.geyser.platform.bungeecord.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.geysermc.geyser.platform.bungeecord.shaded.com.fasterxml.jackson.core.JsonParser;
import org.geysermc.geyser.platform.bungeecord.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.geysermc.geyser.platform.bungeecord.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.geysermc.geyser.platform.bungeecord.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;

public final class GeyserResourcePackManifest
extends Record
implements ResourcePackManifest {
    @JsonProperty(value="format_version")
    private final int formatVersion;
    private final Header header;
    private final Collection<Module> modules;
    private final Collection<Dependency> dependencies;
    private final Collection<Subpack> subpacks;
    private final Collection<Setting> settings;

    public GeyserResourcePackManifest(int formatVersion, Header header, Collection<Module> modules, Collection<Dependency> dependencies, Collection<Subpack> subpacks, Collection<Setting> settings) {
        this.formatVersion = formatVersion;
        this.header = header;
        this.modules = GeyserResourcePackManifest.ensureNonNull(modules);
        this.dependencies = GeyserResourcePackManifest.ensureNonNull(dependencies);
        this.subpacks = GeyserResourcePackManifest.ensureNonNull(subpacks);
        this.settings = GeyserResourcePackManifest.ensureNonNull(settings);
    }

    static <T> Collection<T> ensureNonNull(Collection<T> collection) {
        if (collection == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(collection);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{GeyserResourcePackManifest.class, "formatVersion;header;modules;dependencies;subpacks;settings", "formatVersion", "header", "modules", "dependencies", "subpacks", "settings"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{GeyserResourcePackManifest.class, "formatVersion;header;modules;dependencies;subpacks;settings", "formatVersion", "header", "modules", "dependencies", "subpacks", "settings"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{GeyserResourcePackManifest.class, "formatVersion;header;modules;dependencies;subpacks;settings", "formatVersion", "header", "modules", "dependencies", "subpacks", "settings"}, this, o);
    }

    @Override
    @JsonProperty(value="format_version")
    public int formatVersion() {
        return this.formatVersion;
    }

    @Override
    public Header header() {
        return this.header;
    }

    public Collection<Module> modules() {
        return this.modules;
    }

    public Collection<Dependency> dependencies() {
        return this.dependencies;
    }

    public Collection<Subpack> subpacks() {
        return this.subpacks;
    }

    public Collection<Setting> settings() {
        return this.settings;
    }

    public static final class Header
    extends Record
    implements ResourcePackManifest.Header {
        private final UUID uuid;
        private final Version version;
        private final String name;
        private final String description;
        @JsonProperty(value="min_engine_version")
        private final Version minimumSupportedMinecraftVersion;

        public Header(UUID uuid, Version version, String name, String description, @JsonProperty(value="min_engine_version") Version minimumSupportedMinecraftVersion) {
            this.uuid = uuid;
            this.version = version;
            this.name = name;
            this.description = description;
            this.minimumSupportedMinecraftVersion = minimumSupportedMinecraftVersion;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Header.class, "uuid;version;name;description;minimumSupportedMinecraftVersion", "uuid", "version", "name", "description", "minimumSupportedMinecraftVersion"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Header.class, "uuid;version;name;description;minimumSupportedMinecraftVersion", "uuid", "version", "name", "description", "minimumSupportedMinecraftVersion"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Header.class, "uuid;version;name;description;minimumSupportedMinecraftVersion", "uuid", "version", "name", "description", "minimumSupportedMinecraftVersion"}, this, o);
        }

        @Override
        public UUID uuid() {
            return this.uuid;
        }

        @Override
        public Version version() {
            return this.version;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String description() {
            return this.description;
        }

        @Override
        @JsonProperty(value="min_engine_version")
        public Version minimumSupportedMinecraftVersion() {
            return this.minimumSupportedMinecraftVersion;
        }
    }

    @JsonDeserialize(using=VersionDeserializer.class)
    public record Version(int major, int minor, int patch) implements ResourcePackManifest.Version
    {
        @Override
        public @NonNull String toString() {
            return this.major + "." + this.minor + "." + this.patch;
        }

        public static class VersionDeserializer
        extends JsonDeserializer<Version> {
            @Override
            public Version deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                int[] version = ctxt.readValue(p, int[].class);
                return new Version(version[0], version[1], version[2]);
            }
        }
    }

    public record Setting(String type, String text) implements ResourcePackManifest.Setting
    {
    }

    public record Subpack(@JsonProperty(value="folder_name") String folderName, String name, @JsonProperty(value="memory_tier") Float memoryTier) implements ResourcePackManifest.Subpack
    {
    }

    public static final class Dependency
    extends Record
    implements ResourcePackManifest.Dependency {
        private final UUID uuid;
        private final Version version;

        public Dependency(UUID uuid, Version version) {
            this.uuid = uuid;
            this.version = version;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Dependency.class, "uuid;version", "uuid", "version"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Dependency.class, "uuid;version", "uuid", "version"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Dependency.class, "uuid;version", "uuid", "version"}, this, o);
        }

        @Override
        public UUID uuid() {
            return this.uuid;
        }

        @Override
        public Version version() {
            return this.version;
        }
    }

    public static final class Module
    extends Record
    implements ResourcePackManifest.Module {
        private final UUID uuid;
        private final Version version;
        private final String type;
        private final String description;

        public Module(UUID uuid, Version version, String type, String description) {
            this.uuid = uuid;
            this.version = version;
            this.type = type;
            this.description = description;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Module.class, "uuid;version;type;description", "uuid", "version", "type", "description"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Module.class, "uuid;version;type;description", "uuid", "version", "type", "description"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Module.class, "uuid;version;type;description", "uuid", "version", "type", "description"}, this, o);
        }

        @Override
        public UUID uuid() {
            return this.uuid;
        }

        @Override
        public Version version() {
            return this.version;
        }

        @Override
        public String type() {
            return this.type;
        }

        @Override
        public String description() {
            return this.description;
        }
    }
}

