/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.pack;

import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.api.pack.PackCodec;
import org.geysermc.geyser.api.pack.ResourcePack;
import org.geysermc.geyser.api.pack.ResourcePackManifest;
import org.geysermc.geyser.api.pack.option.PriorityOption;
import org.geysermc.geyser.pack.GeyserResourcePack;
import org.geysermc.geyser.pack.option.OptionHolder;

public record ResourcePackHolder(@NonNull GeyserResourcePack pack, @NonNull OptionHolder optionHolder) {
    public static ResourcePackHolder of(GeyserResourcePack pack) {
        return new ResourcePackHolder(pack, new OptionHolder(PriorityOption.NORMAL));
    }

    public ResourcePack resourcePack() {
        return this.pack;
    }

    public PackCodec codec() {
        return this.pack.codec();
    }

    public UUID uuid() {
        return this.pack.uuid();
    }

    public ResourcePackManifest.Version version() {
        return this.pack.manifest().header().version();
    }

    public ResourcePackHolder withPack(@NonNull GeyserResourcePack pack) {
        if (pack == null) {
            throw new NullPointerException("pack is marked non-null but is null");
        }
        return this.pack == pack ? this : new ResourcePackHolder(pack, this.optionHolder);
    }

    public ResourcePackHolder withOptionHolder(@NonNull OptionHolder optionHolder) {
        if (optionHolder == null) {
            throw new NullPointerException("optionHolder is marked non-null but is null");
        }
        return this.optionHolder == optionHolder ? this : new ResourcePackHolder(this.pack, optionHolder);
    }
}

