/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.text;

import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Optional;
import org.geysermc.geyser.platform.bungeecord.shaded.com.fasterxml.jackson.annotation.JacksonAnnotationsInside;
import org.geysermc.geyser.platform.bungeecord.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.geysermc.geyser.platform.bungeecord.shaded.com.fasterxml.jackson.databind.BeanProperty;
import org.geysermc.geyser.platform.bungeecord.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import org.geysermc.geyser.platform.bungeecord.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.geysermc.geyser.platform.bungeecord.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.geysermc.geyser.platform.bungeecord.shaded.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import org.geysermc.geyser.platform.bungeecord.shaded.com.fasterxml.jackson.databind.ser.std.StdSerializer;

public class AsteriskSerializer
extends StdSerializer<Object>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    public static final String[] NON_SENSITIVE_ADDRESSES = new String[]{"", "0.0.0.0", "localhost", "127.0.0.1", "auto", "unknown"};
    public static boolean showSensitive = false;
    String asterisk;
    boolean isIp;

    public AsteriskSerializer() {
        super(Object.class);
    }

    public AsteriskSerializer(String asterisk, boolean isIp) {
        super(Object.class);
        this.asterisk = asterisk;
        this.isIp = isIp;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty property) {
        Optional<Asterisk> anno = Optional.ofNullable(property).map(prop -> prop.getAnnotation(Asterisk.class));
        return new AsteriskSerializer(anno.map(Asterisk::value).orElse(null), (boolean)anno.map(Asterisk::isIp).orElse(false));
    }

    @Override
    public void serialize(Object obj, JsonGenerator gen, SerializerProvider prov) throws IOException {
        if (this.isIp && (showSensitive || !this.isSensitiveIp((String)obj))) {
            gen.writeObject(obj);
            return;
        }
        gen.writeString(this.asterisk);
    }

    private boolean isSensitiveIp(String ip) {
        for (String address : NON_SENSITIVE_ADDRESSES) {
            if (!address.equalsIgnoreCase(ip)) continue;
            return false;
        }
        return true;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @JacksonAnnotationsInside
    @JsonSerialize(using=AsteriskSerializer.class)
    public static @interface Asterisk {
        public String value() default "***";

        public boolean isIp() default false;
    }
}

