/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory;

import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.geyser.translator.item.ItemTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.ContainerType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.LodestoneTracker;
import org.jetbrains.annotations.Range;

public abstract class Inventory {
    protected final int javaId;
    private int bedrockId;
    private int stateId;
    private int nextStateId = -1;
    protected final int size;
    protected final ContainerType containerType;
    protected final String title;
    protected final GeyserItemStack[] items;
    protected Vector3i holderPosition = Vector3i.ZERO;
    protected long holderId = -1L;
    private boolean pending = false;
    private boolean displayed = false;
    private final InventoryTranslator translator;
    private final GeyserSession session;

    protected Inventory(GeyserSession session, int id, int size, ContainerType containerType, InventoryTranslator translator) {
        this(session, "Inventory", id, size, containerType, translator);
    }

    protected Inventory(GeyserSession session, String title, int javaId, int size, ContainerType containerType, InventoryTranslator translator) {
        this.title = title;
        this.javaId = javaId;
        this.size = size;
        this.containerType = containerType;
        this.items = new GeyserItemStack[size];
        Arrays.fill(this.items, GeyserItemStack.EMPTY);
        this.translator = translator;
        this.session = session;
        int n = this.bedrockId = javaId <= 100 ? javaId : javaId % 100 + 1;
        if (session.getOpenInventory() != null && session.getOpenInventory().getBedrockId() == this.bedrockId || session.isClosingInventory()) {
            ++this.bedrockId;
        }
    }

    public GeyserItemStack getItem(int slot) {
        if (slot > this.size) {
            GeyserImpl.getInstance().getLogger().debug("Tried to get an item out of bounds! " + String.valueOf(this));
            return GeyserItemStack.EMPTY;
        }
        return this.items[slot];
    }

    public abstract int getOffsetForHotbar(@Range(from=0L, to=8L) int var1);

    public void setItem(int slot, @NonNull GeyserItemStack newItem, GeyserSession session) {
        LodestoneTracker tracker;
        if (slot > this.size) {
            session.getGeyser().getLogger().debug("Tried to set an item out of bounds! " + String.valueOf(this));
            return;
        }
        GeyserItemStack oldItem = this.items[slot];
        Inventory.updateItemNetId(oldItem, newItem, session);
        this.items[slot] = newItem;
        if (newItem.asItem() == Items.COMPASS && (tracker = (LodestoneTracker)newItem.getComponent(DataComponentTypes.LODESTONE_TRACKER)) != null) {
            session.getLodestoneCache().cacheInventoryItem(newItem, tracker);
        }
    }

    public static void updateItemNetId(GeyserItemStack oldItem, GeyserItemStack newItem, GeyserSession session) {
        if (!newItem.isEmpty()) {
            ItemDefinition newMapping;
            ItemDefinition oldMapping = ItemTranslator.getBedrockItemDefinition(session, oldItem);
            if (oldMapping.equals(newMapping = ItemTranslator.getBedrockItemDefinition(session, newItem))) {
                newItem.setNetId(oldItem.getNetId());
                newItem.mergeBundleData(session, oldItem.getBundleData());
            } else {
                newItem.setNetId(session.getNextItemNetId());
                session.getBundleCache().markNewBundle(newItem.getBundleData());
                session.getBundleCache().onOldItemDelete(oldItem);
            }
        } else {
            session.getBundleCache().onOldItemDelete(oldItem);
        }
    }

    public void incrementStateId(int count) {
        this.nextStateId = (this.nextStateId == -1 ? this.stateId : this.nextStateId) + count & Short.MAX_VALUE;
    }

    public void resetNextStateId() {
        this.nextStateId = -1;
    }

    public boolean shouldConfirmContainerClose() {
        return true;
    }

    public void updateInventory() {
        this.translator.updateInventory(this.session, this);
    }

    public void updateProperty(int rawProperty, int value) {
        this.translator.updateProperty(this.session, this, rawProperty, value);
    }

    public void updateSlot(int slot) {
        this.translator.updateSlot(this.session, this, slot);
    }

    public String toString() {
        return "Inventory(javaId=" + this.getJavaId() + ", bedrockId=" + this.getBedrockId() + ", stateId=" + this.getStateId() + ", nextStateId=" + this.getNextStateId() + ", size=" + this.getSize() + ", containerType=" + String.valueOf(this.getContainerType()) + ", title=" + this.getTitle() + ", items=" + Arrays.deepToString(this.items) + ", holderPosition=" + String.valueOf(this.getHolderPosition()) + ", holderId=" + this.getHolderId() + ", pending=" + this.isPending() + ", displayed=" + this.isDisplayed() + ", translator=" + String.valueOf(this.getTranslator()) + ", session=" + String.valueOf(this.getSession()) + ")";
    }

    public int getJavaId() {
        return this.javaId;
    }

    public void setBedrockId(int bedrockId) {
        this.bedrockId = bedrockId;
    }

    public int getBedrockId() {
        return this.bedrockId;
    }

    public int getStateId() {
        return this.stateId;
    }

    public void setStateId(int stateId) {
        this.stateId = stateId;
    }

    public int getNextStateId() {
        return this.nextStateId;
    }

    public int getSize() {
        return this.size;
    }

    public ContainerType getContainerType() {
        return this.containerType;
    }

    public String getTitle() {
        return this.title;
    }

    public Vector3i getHolderPosition() {
        return this.holderPosition;
    }

    public void setHolderPosition(Vector3i holderPosition) {
        this.holderPosition = holderPosition;
    }

    public long getHolderId() {
        return this.holderId;
    }

    public void setHolderId(long holderId) {
        this.holderId = holderId;
    }

    public boolean isPending() {
        return this.pending;
    }

    public void setPending(boolean pending) {
        this.pending = pending;
    }

    public boolean isDisplayed() {
        return this.displayed;
    }

    public void setDisplayed(boolean displayed) {
        this.displayed = displayed;
    }

    public InventoryTranslator getTranslator() {
        return this.translator;
    }

    public GeyserSession getSession() {
        return this.session;
    }
}

